# 商户升级
## 提交升级申请单

使用“提交升级申请单”接口为小微商户发起升级流程，根据商户实际情况可升级为个体户、企业、党政、机关及事业单位、其他组织。。

```php
$result = $app->upgrade([
    'organization_type' => '2', // 主体类型
    'business_license_copy'  => 'media_id', // 营业执照扫描件
    // ...
    // 参数太多就不一一列出，自行根据 (小微商户专属文档 -> 提交升级申请单API) 填写
]);
```

## 查询升级申请单状态
使用“提交升级申请单”接口后，可不定期调用此接口查询申请单状态（建议提交申请后1分钟查询），直至申请单为“完成”状态。

1)若申请状态为待账户验证，请按接口中的指引完成账户验证

2)若申请状态为审核中，微信支付会在2个工作日内完成资料审核

3)若申请状态为待签约，接口会返回签约二维码

```php
$app->getUpgradeStatus(string $subMchId = '');
```
> 调用该接口前调用过 `setSubMchId` 方法则无需传入 `$subMchId` 参数
