
-- ----------------------------
DROP TABLE IF EXISTS `wxb_admin`;
CREATE TABLE `wxb_admin`  (
  `admin_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `username` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `password` char(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `mobile` char(11) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `role` tinyint(1) NULL DEFAULT 1 COMMENT '1 超级管理员   2普通管理员',
  `auth` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '对应的权限授权的KEY',
  `is_delete` tinyint(1) NULL DEFAULT 0,
  `last_time` int(11) NULL DEFAULT 0,
  `add_time` int(11) NULL DEFAULT NULL,
  `add_ip` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`admin_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '后台表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for wxb_angling
-- ----------------------------
DROP TABLE IF EXISTS `wxb_angling`;
CREATE TABLE `wxb_angling`  (
  `angling_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `city_id` int(11) NULL DEFAULT NULL,
  `photos` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `fish_type` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '1,2,3 以逗号分隔',
  `addr` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `lat` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `lng` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `mobile` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '手机号码',
  `weixin` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `rank_num` int(11) NULL DEFAULT 0,
  `is_tai` tinyint(1) NULL DEFAULT 0,
  `is_lure` tinyint(1) NULL DEFAULT 0,
  `detail` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '鱼塘介绍',
  `is_audit` tinyint(1) NULL DEFAULT 0,
  `add_time` int(11) NULL DEFAULT NULL,
  `add_ip` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`angling_id`) USING BTREE
) ENGINE = InnoDB  CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '黑坑表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for wxb_angling_bank
-- ----------------------------
DROP TABLE IF EXISTS `wxb_angling_bank`;
CREATE TABLE `wxb_angling_bank`  (
  `angling_id` int(11) NOT NULL,
  `bank_name` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '银行名称',
  `bank_number` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '银行账号',
  `bank_account` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开户名',
  `add_time` int(11) NULL DEFAULT NULL,
  `add_ip` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`angling_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for wxb_angling_cash
-- ----------------------------
DROP TABLE IF EXISTS `wxb_angling_cash`;
CREATE TABLE `wxb_angling_cash`  (
  `log_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `angling_id` int(11) NULL DEFAULT NULL,
  `total_money` decimal(10, 2) NULL DEFAULT 0.00,
  `free` decimal(10, 2) NULL DEFAULT 0.00,
  `money` decimal(10, 2) NULL DEFAULT 0.00,
  `free_money` decimal(10, 2) NULL DEFAULT 0.00,
  `status` tinyint(1) NULL DEFAULT 0 COMMENT '0 等待处理 1已完成',
  `bank_name` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `bank_number` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `bank_account` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `add_time` int(11) NULL DEFAULT NULL,
  `add_ip` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`log_id`) USING BTREE
) ENGINE = InnoDB  CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '提现表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for wxb_angling_discount
-- ----------------------------
DROP TABLE IF EXISTS `wxb_angling_discount`;
CREATE TABLE `wxb_angling_discount`  (
  `discount_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `angling_id` int(11) NULL DEFAULT NULL,
  `discount` decimal(5, 1) NULL DEFAULT NULL,
  `is_open` tinyint(1) NULL DEFAULT 0 COMMENT '是否开启',
  `add_time` int(11) NULL DEFAULT NULL,
  `add_ip` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`discount_id`) USING BTREE
) ENGINE = InnoDB  CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for wxb_angling_free
-- ----------------------------
DROP TABLE IF EXISTS `wxb_angling_free`;
CREATE TABLE `wxb_angling_free`  (
  `free_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `angling_id` int(11) NULL DEFAULT NULL,
  `free` decimal(10, 2) NULL DEFAULT NULL COMMENT '签约费率',
  `level` tinyint(1) NULL DEFAULT 0 COMMENT '级别  0 默认级别  1活动优先级别',
  `bg_time` datetime NULL DEFAULT NULL,
  `end_time` datetime NULL DEFAULT NULL,
  `add_time` int(11) NULL DEFAULT NULL,
  `add_ip` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`free_id`) USING BTREE
) ENGINE = InnoDB  CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '服务费签约表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for wxb_angling_manage
-- ----------------------------
DROP TABLE IF EXISTS `wxb_angling_manage`;
CREATE TABLE `wxb_angling_manage`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `angling_id` int(11) NULL DEFAULT NULL,
  `member_id` int(11) NULL DEFAULT NULL,
  `role` tinyint(1) NULL DEFAULT 0 COMMENT '1老板  2管理',
  `add_time` int(11) NULL DEFAULT NULL,
  `add_ip` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB  CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '黑坑管理员表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for wxb_angling_money_logs
-- ----------------------------
DROP TABLE IF EXISTS `wxb_angling_money_logs`;
CREATE TABLE `wxb_angling_money_logs`  (
  `log_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `angling_id` int(11) NULL DEFAULT NULL,
  `order_id` int(11) NULL DEFAULT 0 COMMENT '来源订单',
  `money` decimal(10, 2) NULL DEFAULT NULL,
  `status` tinyint(1) NULL DEFAULT 0 COMMENT '0 待生成结算账单的',
  `add_time` int(11) NULL DEFAULT NULL,
  `add_ip` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`log_id`) USING BTREE
) ENGINE = InnoDB  CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for wxb_angling_tuan
-- ----------------------------
DROP TABLE IF EXISTS `wxb_angling_tuan`;
CREATE TABLE `wxb_angling_tuan`  (
  `tuan_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `angling_id` int(11) NULL DEFAULT NULL,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标题中请带有比如说大混养3小时 5小时等',
  `price` decimal(10, 2) NULL DEFAULT NULL,
  `original_price` decimal(10, 2) NULL DEFAULT 0.00 COMMENT '原价',
  `num` int(11) NULL DEFAULT 0 COMMENT '剩余数量',
  `sold_num` int(11) NULL DEFAULT 0,
  `day` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '例如周一至周五  周六日可用 等文字说明',
  `add_time` int(11) NULL DEFAULT NULL,
  `add_ip` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`tuan_id`) USING BTREE
) ENGINE = InnoDB  CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for wxb_angling_vip
-- ----------------------------
DROP TABLE IF EXISTS `wxb_angling_vip`;
CREATE TABLE `wxb_angling_vip`  (
  `vip_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `angling_id` int(11) NULL DEFAULT NULL,
  `name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `mobile` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `weixin` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `money` decimal(10, 2) NULL DEFAULT 0.00 COMMENT '余额',
  `add_time` int(11) NULL DEFAULT NULL,
  `add_ip` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`vip_id`) USING BTREE
) ENGINE = InnoDB  CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for wxb_angling_vip_money_log
-- ----------------------------
DROP TABLE IF EXISTS `wxb_angling_vip_money_log`;
CREATE TABLE `wxb_angling_vip_money_log`  (
  `log_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `vip_id` int(11) NULL DEFAULT NULL,
  `angling_id` int(11) NULL DEFAULT NULL,
  `type` tinyint(1) NULL DEFAULT 0 COMMENT '1 增加  2减少',
  `money` decimal(10, 2) NULL DEFAULT 0.00,
  `add_time` int(11) NULL DEFAULT NULL,
  `add_ip` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`log_id`) USING BTREE
) ENGINE = InnoDB  CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for wxb_angling_vip_project
-- ----------------------------
DROP TABLE IF EXISTS `wxb_angling_vip_project`;
CREATE TABLE `wxb_angling_vip_project`  (
  `project_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `vip_id` int(11) NULL DEFAULT NULL,
  `angling_id` int(11) NULL DEFAULT 0,
  `name` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `num` int(11) NULL DEFAULT NULL,
  `expire_date` date NULL DEFAULT NULL,
  `add_time` int(11) NULL DEFAULT NULL,
  `add_ip` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`project_id`) USING BTREE
) ENGINE = InnoDB  CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for wxb_angling_vip_project_log
-- ----------------------------
DROP TABLE IF EXISTS `wxb_angling_vip_project_log`;
CREATE TABLE `wxb_angling_vip_project_log`  (
  `log_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `vip_id` int(11) NULL DEFAULT NULL,
  `angling_id` int(11) NULL DEFAULT NULL,
  `type` tinyint(1) NULL DEFAULT 0 COMMENT '1增加 2 减少',
  `project_id` int(11) NULL DEFAULT NULL,
  `num` int(11) NULL DEFAULT 0,
  `add_time` int(11) NULL DEFAULT NULL,
  `add_ip` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`log_id`) USING BTREE
) ENGINE = InnoDB  CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for wxb_coupon
-- ----------------------------
DROP TABLE IF EXISTS `wxb_coupon`;
CREATE TABLE `wxb_coupon`  (
  `coupon_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '比如百万补贴助力钓友钓好鱼',
  `money` decimal(10, 2) NULL DEFAULT NULL,
  `need_money` decimal(10, 2) NULL DEFAULT 0.00 COMMENT '满多少可用',
  `num` int(11) NULL DEFAULT 0,
  `bg_time` date NULL DEFAULT NULL,
  `day` smallint(6) NULL DEFAULT 30 COMMENT '领取或者兑换后多久内使用，超时则过期',
  `type` tinyint(1) NULL DEFAULT 0 COMMENT '类型',
  `exchange_num` int(11) NULL DEFAULT 0 COMMENT '需要得鱼饵',
  `add_time` int(11) NULL DEFAULT NULL,
  `add_ip` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`coupon_id`) USING BTREE
) ENGINE = InnoDB  CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '平台补贴优惠券表，本补贴单个用户仅能参与一次' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for wxb_data_banner
-- ----------------------------
DROP TABLE IF EXISTS `wxb_data_banner`;
CREATE TABLE `wxb_data_banner`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `city_id` int(11) NULL DEFAULT 0 COMMENT '0 代表所有城市都显示',
  `photo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `link_type` tinyint(1) NULL DEFAULT 0 COMMENT '1页面  2小程序',
  `link_appid` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `link_path` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `sort` int(11) NULL DEFAULT NULL COMMENT '数值越大排序越高',
  `add_time` int(11) NULL DEFAULT NULL,
  `add_ip` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB  CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for wxb_data_city
-- ----------------------------
DROP TABLE IF EXISTS `wxb_data_city`;
CREATE TABLE `wxb_data_city`  (
  `city_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `lat` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `lng` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `is_open` tinyint(1) NULL DEFAULT 0,
  `is_hot` tinyint(1) NULL DEFAULT 0,
  `add_time` int(11) NULL DEFAULT NULL,
  `add_ip` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`city_id`) USING BTREE
) ENGINE = InnoDB  CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for wxb_data_setting
-- ----------------------------
DROP TABLE IF EXISTS `wxb_data_setting`;
CREATE TABLE `wxb_data_setting`  (
  `k` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `v` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  PRIMARY KEY (`k`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for wxb_explore
-- ----------------------------
DROP TABLE IF EXISTS `wxb_explore`;
CREATE TABLE `wxb_explore`  (
  `explore_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `city_id` int(11) NULL DEFAULT NULL,
  `angling_id` int(11) NULL DEFAULT NULL,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `photo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `original_price` decimal(10, 2) NULL DEFAULT NULL,
  `price` decimal(10, 2) NULL DEFAULT NULL,
  `num` int(11) NULL DEFAULT NULL,
  `detail` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `status` tinyint(1) NULL DEFAULT 0 COMMENT '0 下架中 1上架中',
  `add_time` int(11) NULL DEFAULT NULL,
  `add_ip` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`explore_id`) USING BTREE
) ENGINE = InnoDB  CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '探一探 给钓场拉新,本次拉新计划' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for wxb_huodong
-- ----------------------------
DROP TABLE IF EXISTS `wxb_huodong`;
CREATE TABLE `wxb_huodong`  (
  `huodong_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `city_id` int(11) NULL DEFAULT 0,
  `angling_id` int(11) NULL DEFAULT NULL,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `photo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `original_price` decimal(10, 2) NULL DEFAULT 0.00 COMMENT '原价',
  `price` decimal(10, 2) NULL DEFAULT NULL COMMENT '现价',
  `num` int(11) NULL DEFAULT NULL COMMENT '多少人成团',
  `sold_num` int(11) NULL DEFAULT 0,
  `fishing_day` date NULL DEFAULT NULL COMMENT '钓鱼日期',
  `detail` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '活动说明',
  `status` tinyint(1) NULL DEFAULT 0 COMMENT '0 等待开启   1报名中 8报名结束',
  `day` int(11) NULL DEFAULT NULL COMMENT '取消提前天数',
  `hour` int(11) NULL DEFAULT NULL COMMENT '取消提前小时',
  `day_refund` decimal(11, 2) NULL DEFAULT NULL COMMENT '退款百分比',
  `hour_refund` decimal(11, 2) NULL DEFAULT NULL COMMENT '退款百分比',
  `add_time` int(11) NULL DEFAULT NULL,
  `add_ip` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`huodong_id`) USING BTREE
) ENGINE = InnoDB  CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for wxb_img_album
-- ----------------------------
DROP TABLE IF EXISTS `wxb_img_album`;
CREATE TABLE `wxb_img_album`  (
  `album_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`album_id`) USING BTREE
) ENGINE = InnoDB  CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for wxb_img_log
-- ----------------------------
DROP TABLE IF EXISTS `wxb_img_log`;
CREATE TABLE `wxb_img_log`  (
  `img_id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `from_type` enum('miniapp','admin') CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT 'admin' COMMENT '从哪里上传的',
  `type` tinyint(1) NULL DEFAULT 0 COMMENT '0 图片  1视频',
  `album_id` int(11) NULL DEFAULT 0 COMMENT '商户上传的会关联商户的相册，目前还没有',
  `member_id` int(11) NULL DEFAULT 0 COMMENT '用户ID',
  `hash` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '七牛云返回量',
  `key` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '七牛云返回量',
  `url` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '图片链接',
  `size` double(10, 2) NULL DEFAULT 0.00 COMMENT '图片大小',
  `ext` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '图片格式',
  `is_delete` tinyint(2) NULL DEFAULT 0 COMMENT '是否删除',
  `add_time` int(11) NULL DEFAULT NULL COMMENT '添加时间',
  `add_ip` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '添加时的ip',
  PRIMARY KEY (`img_id`) USING BTREE
) ENGINE = InnoDB  CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for wxb_lottery
-- ----------------------------
DROP TABLE IF EXISTS `wxb_lottery`;
CREATE TABLE `wxb_lottery`  (
  `lottery_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
  `exclusive` int(11) NULL DEFAULT NULL COMMENT '独享鱼饵',
  `luck_num` int(11) NULL DEFAULT NULL,
  `luck_min` int(11) NULL DEFAULT 0,
  `luck_max` int(11) NULL DEFAULT 0,
  `bg_time` datetime NULL DEFAULT NULL,
  `open_time` datetime NULL DEFAULT NULL,
  `status` tinyint(1) NULL DEFAULT 0 COMMENT '0  和 8 2个状态  8代表已经开奖',
  `add_time` int(11) NULL DEFAULT NULL,
  `add_ip` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`lottery_id`) USING BTREE
) ENGINE = InnoDB  CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for wxb_lottery_join
-- ----------------------------
DROP TABLE IF EXISTS `wxb_lottery_join`;
CREATE TABLE `wxb_lottery_join`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `member_id` int(11) NULL DEFAULT NULL,
  `lottery_id` int(11) NULL DEFAULT NULL,
  `status` tinyint(1) NULL DEFAULT 0 COMMENT '0 等待开奖  1独享大奖  2幸运奖  4未中奖',
  `rate` int(11) NULL DEFAULT 0 COMMENT '倍数值，排名用 排名越高中奖概率越大',
  `add_time` int(11) NULL DEFAULT NULL,
  `add_ip` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB  CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for wxb_member
-- ----------------------------
DROP TABLE IF EXISTS `wxb_member`;
CREATE TABLE `wxb_member`  (
  `member_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `open_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `mobile` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `nickname` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `face` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `integral` int(11) NULL DEFAULT 0,
  `city_id` int(11) NULL DEFAULT 0 COMMENT '所在城市',
  `is_delete` tinyint(1) NULL DEFAULT 0,
  `is_new` tinyint(1) NULL DEFAULT 0 COMMENT '未下过任何订单的用户',
  `pid` tinyint(1) NULL DEFAULT 0 COMMENT '来自哪个团长邀请的',
  `add_time` int(11) NULL DEFAULT NULL,
  `add_ip` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`member_id`) USING BTREE,
  UNIQUE INDEX `open_id`(`open_id`) USING BTREE
) ENGINE = InnoDB  CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for wxb_member_clock
-- ----------------------------
DROP TABLE IF EXISTS `wxb_member_clock`;
CREATE TABLE `wxb_member_clock`  (
  `clock_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `member_id` int(11) NULL DEFAULT NULL,
  `city_id` int(11) NULL DEFAULT NULL,
  `type` tinyint(1) NULL DEFAULT 0 COMMENT '1 野钓  2黑坑',
  `rapac_id` int(11) NULL DEFAULT 0 COMMENT '打卡的野钓点ID',
  `angling_id` int(11) NULL DEFAULT 0 COMMENT '打卡的黑坑ID',
  `desc` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '说点什么',
  `photos` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `status` tinyint(1) NULL DEFAULT 0 COMMENT '0待审核 1已审核',
  `add_time` int(11) NULL DEFAULT NULL,
  `add_ip` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`clock_id`) USING BTREE
) ENGINE = InnoDB  CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for wxb_member_coupon
-- ----------------------------
DROP TABLE IF EXISTS `wxb_member_coupon`;
CREATE TABLE `wxb_member_coupon`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `member_id` int(11) NULL DEFAULT NULL,
  `coupon_id` int(11) NULL DEFAULT NULL,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `money` decimal(10, 2) NULL DEFAULT NULL,
  `need_money` decimal(10, 2) NULL DEFAULT NULL,
  `bg_time` date NULL DEFAULT NULL,
  `expire_time` date NULL DEFAULT NULL,
  `status` tinyint(1) NULL DEFAULT 0,
  `add_time` int(11) NULL DEFAULT NULL,
  `add_ip` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB  CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for wxb_member_integral
-- ----------------------------
DROP TABLE IF EXISTS `wxb_member_integral`;
CREATE TABLE `wxb_member_integral`  (
  `log_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `member_id` int(11) NULL DEFAULT NULL,
  `type` tinyint(1) NULL DEFAULT 0 COMMENT '1 增加 2减少',
  `info` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '原由',
  `num` int(11) NULL DEFAULT 0,
  `add_time` int(11) NULL DEFAULT NULL,
  `add_ip` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`log_id`) USING BTREE
) ENGINE = InnoDB  CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for wxb_mp_keyword
-- ----------------------------
DROP TABLE IF EXISTS `wxb_mp_keyword`;
CREATE TABLE `wxb_mp_keyword`  (
  `keyword_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `keyword` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `type` tinyint(1) NULL DEFAULT 0,
  `content` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `desc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `photo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `add_time` int(11) NULL DEFAULT NULL,
  `add_ip` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`keyword_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for wxb_order
-- ----------------------------
DROP TABLE IF EXISTS `wxb_order`;
CREATE TABLE `wxb_order`  (
  `order_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `city_id` int(11) NULL DEFAULT NULL,
  `angling_id` int(11) NULL DEFAULT NULL,
  `member_id` int(11) NULL DEFAULT NULL,
  `type` tinyint(2) NULL DEFAULT 0 COMMENT '1、抢购  2、拼一拼  3、探一探',
  `data_id` int(11) NULL DEFAULT NULL COMMENT '保留原有的来源产品ID',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `photo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `price` decimal(10, 2) NULL DEFAULT 0.00,
  `coupon` decimal(10, 2) NULL DEFAULT 0.00,
  `coupon_id` int(11) NULL DEFAULT 0,
  `num` int(11) NULL DEFAULT 0 COMMENT '购买的数量',
  `use_num` int(11) NULL DEFAULT 0 COMMENT '已经使用的数量',
  `total_price` decimal(10, 2) NULL DEFAULT 0.00,
  `need_pay` decimal(10, 2) NULL DEFAULT 0.00,
  `is_paid` tinyint(1) NULL DEFAULT 0,
  `pay_time` int(11) NULL DEFAULT 0,
  `pay_info` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `ext_info` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '数组需要冗余的字段',
  `status` tinyint(1) NULL DEFAULT 0 COMMENT '0待使用  8已经使用   2申请退款  3已退款   4 已取消',
  `refund_time` int(11) NULL DEFAULT NULL COMMENT '申请退款的时间（会计算提前的时间为多少返回对应的比率）',
  `refund_money` decimal(10, 2) NULL DEFAULT 0.00 COMMENT '实退金额',
  `add_time` int(11) NULL DEFAULT NULL,
  `add_ip` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`order_id`) USING BTREE
) ENGINE = InnoDB  CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for wxb_order_use_logs
-- ----------------------------
DROP TABLE IF EXISTS `wxb_order_use_logs`;
CREATE TABLE `wxb_order_use_logs`  (
  `log_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NULL DEFAULT NULL,
  `angling_id` int(11) NULL DEFAULT NULL,
  `member_id` int(11) NULL DEFAULT NULL,
  `num` int(11) NULL DEFAULT NULL,
  `add_time` int(11) NULL DEFAULT NULL,
  `add_ip` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`log_id`) USING BTREE
) ENGINE = InnoDB  CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for wxb_rapac
-- ----------------------------
DROP TABLE IF EXISTS `wxb_rapac`;
CREATE TABLE `wxb_rapac`  (
  `rapac_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `city_id` int(11) NULL DEFAULT 0,
  `name` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `photos` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `fish_type` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '逗号隔开',
  `desc` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '钓点说明',
  `lat` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `lng` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `is_cat` tinyint(1) NULL DEFAULT 0 COMMENT '车能到岸边 1是 0 否',
  `is_lure` tinyint(1) NULL DEFAULT 0 COMMENT '是否路亚',
  `member_id` int(11) NULL DEFAULT NULL COMMENT '来源提交的人',
  `is_audit` tinyint(1) NULL DEFAULT 0 COMMENT '是否在审核',
  `add_time` int(11) NULL DEFAULT NULL,
  `add_ip` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`rapac_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '野钓表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for wxb_team_building
-- ----------------------------
DROP TABLE IF EXISTS `wxb_team_building`;
CREATE TABLE `wxb_team_building`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `city_id` int(11) NULL DEFAULT NULL,
  `company` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司或者团队名称',
  `num` int(11) NULL DEFAULT NULL COMMENT '团建人数',
  `budget` decimal(10, 2) NULL DEFAULT 0.00 COMMENT '团建预算 ',
  `is_take` tinyint(1) NULL DEFAULT 0 COMMENT '鱼获可带',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `mobile` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `day` date NULL DEFAULT NULL COMMENT '团建日期',
  `info` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '其他需求说明',
  `status` tinyint(1) NULL DEFAULT 0 COMMENT '0 待审核  1已经确认',
  `add_time` int(11) NULL DEFAULT NULL,
  `add_ip` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB  CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '团建订单表' ROW_FORMAT = DYNAMIC;

