<?php
namespace app\mp\controller;
use app\BaseController;
use app\common\helper\mp\MpHelper;
use think\facade\View;
use app\common\helper\payment\PaymentHelper;
use app\common\model\mp\PaymentModel;
class Index extends BaseController{
    
    public function serve(){        
        return MpHelper::getInstance()->serve();
    }
    
    public function payment(){
        $back = $this->request->param('back');
        $id = $this->request->param('id/d');
        if(null === $payOrder = PaymentModel::find($id)){
            return $this->error('请选择要支付的订单');
        }
        if($payOrder->is_paid != 0){
            return $this->error('该订单已经支付');
        }
        $PaymentHelper = new PaymentHelper();
        $res = $PaymentHelper->getPayment([
            'product_name' => $payOrder->goods_name,
            'order_id'     => $id,
            'need_pay'     => $payOrder->total_price,
            'open_id'      => $payOrder->mp_open_id, 
        ]);
        View::assign('payment',$res);
        
        $url =  $this->request->url(true);
        $apis = ['getBrandWCPayRequest'];
        
        $config  = MpHelper::getInstance()->buildConfig($apis, $url);
   
        View::assign('config',$config);
        View::assign('back',$back);
        View::assign('orderId',$payOrder->order_id);
        return View::fetch('payment');
    }
    public function respond(){
        $PaymentHelper = new PaymentHelper();
        return $PaymentHelper->respond();
    }
    public function auth(){
         $back = $this->request->param('back');
         $app  = $this->request->param('app');
         if(empty($back)){
             return $this->error('返回地址不正确');
         }
         $fullBack = env('base_url', 'https://o2o.uniono2o.com/').'mp/back?url='. urlencode($back);
         $url = MpHelper::getInstance()->getAuthUrl($fullBack);
         
         $logic = '\\app\\'.$app.'\\logic\\data\\GlobalDataLogic';
         $site = $logic::getInstance()->getDataByKey('site');
         View::assign('site',$site);
         View::assign('url',$url);
         return View::fetch('auth');
    }
    public function back(){
        $code = $this->request->param('code');
        if(empty($code)){
            return $this->error('登陆参数错误');
        }
        $openId = MpHelper::getInstance()->getUserInfo($code);
        if(empty($openId)){
            return $this->error('登陆解析失败');
        }
        $back = $this->request->param('url');
        header("Location: ".$back .'#/pages/h5/back?openId='.$openId);
        die;
    }
}