<?php
namespace app\home\controller;
use app\BaseController;
use think\facade\View;
use think\facade\Db;
$installLock = root_path().'install.lock';
if(file_exists($installLock)){
    header("Location: /");
    die;
}        
class  Install extends BaseController{
     private $datas = [
        'hostname'  => '',
        'database'  => '',
        'port'      => '',
        'username'  => '',
        'password'  => '',
        'adminuser' => '',
        'adminpwd'  => '',
    ];
    public function index(){
        $step = $this->request->param('step/d',0);
        View::assign('step',$step);
        
        if($step == 1){
           $datas =  $this->check();
           View::assign('checks',$datas['datas']);
           View::assign('isNext',$datas['isNext']);
        }
        return View::fetch('install/index');
        
    }
    
    public function  install(){
        $this->datas['hostname'] = $this->request->param('hostname');
        $this->datas['database'] = $this->request->param('database');
        $this->datas['port']     = $this->request->param('port');
        $this->datas['username'] = $this->request->param('username');
        $this->datas['password'] = $this->request->param('password');
        $this->datas['adminuser']= $this->request->param('adminuser');
        $this->datas['adminpwd'] = $this->request->param('adminpwd');
        if(empty($this->datas['hostname'])){
            $this->showErr('数据库地址不能为空');
        }
        if(empty($this->datas['database'])){
            $this->showErr('数据库不能为空');
        }
        if(empty($this->datas['port'])){
            $this->showErr('数据库端口不能为空');
        }
        if(empty($this->datas['username'])){
            $this->showErr('数据库用户名不能为空');
        }
        if(empty($this->datas['password'])){
            $this->showErr('数据库密码不能为空');
        }
        if(empty($this->datas['adminuser'])){
            $this->showErr('后台用户不能为空');
        }
        if(empty($this->datas['adminpwd'])){
            $this->showErr('后台密码不能为空');
        }
        $this->makeConfig();
		header("Location: /home/install/installSql?admin=".$this->datas['adminuser']."&password=".$this->datas['adminpwd']);
        die;
    }

    public function installSQL(){
		$this->datas['adminuser']= $this->request->param('admin');
		$this->datas['adminpwd'] = $this->request->param('password');
        $sqlFile = root_path().'install.sql';
        $sql = file_get_contents($sqlFile);
        $sqls = explode(';'."\r", $sql);
        try{
            foreach($sqls as $val){
               $val = trim($val);
               if(!empty($val)){
                  Db::execute($val);
               }
            }
            Db::execute("INSERT INTO `wxb_admin` VALUES (1, '".$this->datas['adminuser']."', '".md5($this->datas['adminpwd'])."', '管理员', '13012345678', 1, 0,0,1607417756, 1607417756, '127.0.0.1')");
            
            
            $this->replaceDomain();
            $this->installYes();
        } catch (\Exception $E){
            $this->showErr($E->getMessage());
        }
    }
    
    private function replaceDomain(){
        $dir = [
            $_SERVER['DOCUMENT_ROOT'] .'/superadmin/assets/',
        ];
        $domain = $_SERVER['HTTP_HOST'];
        foreach($dir as $d){
            if(is_dir($d)){
                $files = scandir($d);
                foreach($files as $val){
                    if(strstr($val,'.js')){
                        $str = file_get_contents($d.$val);
                        $str = preg_replace('/pin\.pinyuyu\.com/',$domain, $str);
                        file_put_contents($d.$val, $str);
                    }
                }
            }
        }
    }

    private function makeConfig(){
        $str = 'APP_DEBUG = false'."\r\n".
                'DB_TYPE = mysql'."\r\n".
               'DB_HOST = '.$this->datas['hostname']."\r\n".
               'DB_NAME = '.$this->datas['database']."\r\n".
               'DB_USER = '.$this->datas['username']."\r\n".
               'DB_PASS = '.$this->datas['password']."\r\n".
               'DB_PORT = '.$this->datas['port']."\r\n".
               'DB_CHARSET = utf8'."\r\n".
               'DB_PREFIX  = wxb_'."\r\n".
               'BASE_URL = https://'.$_SERVER['HTTP_HOST'].'/'."\r\n".
               'DEFAULT_LANG = zh-cn';   
        file_put_contents(root_path().'.env', $str);      
        
        $str = '<?php '."\r\n".' return ["code"=>"'.md5(uniqid()).'"];';
        file_put_contents(root_path().'config/auth.php', $str);      
        
    }
    private function installYes(){
        file_put_contents(root_path().'install.lock','合肥微小宝网络科技有限公司技术支持');
        echo  '<script>parent.showInstallStatus(1)</script>';
        die;
    }
    private function showErr($msg){
        echo  '<script>parent.showInstallStatus(2,"'.$msg.'")</script>';
        die;
    }
    
    private  function  check(){
        $datas = [];
        $isNext = 1;
        if(phpversion() >= '8.2.0'){
           $datas[] = ['name'=>'PHP版本最低8.2.0','status'=>1];
        }else{
            $datas[] = ['name'=>'PHP版本最低8.2.0','status'=>-1];
            $isNext = 0;
        }

        if(file_exists($_SERVER['DOCUMENT_ROOT'].'/superadmin')){
            $datas[] = ['name'=>'后台文件检查','status'=>1];
        }else{
            $datas[] = ['name'=>'后台文件检查','status'=>-1];
             $isNext = 0;
        }
      
        return ['datas'=>$datas,'isNext'=>$isNext];
    }
    
    
}