<?php
namespace app\common\validate\admin;

use think\Validate;

class AdminValidate extends Validate {
    
    
    protected $rule = [
        'name'      => ['require','chs'],
        'mobile'    => ['require','mobile'],
        'username'  => ['require','alphaNum'],
        'role'      => ['require','in:1,2']
    ];
    protected $message  =   [
        'name.require' => '真实姓名不能为空',
        'name.chs'     => '真实姓名只能为汉字',
        'mobile.require' => '手机号码不能为空',
        'mobile.mobile' => '手机号码格式不正确',  
        'username.require' => '用户名不能为空',
        'username.alphaNum' => '用户名只能包含数字和字母',
        'role.require'   => '请选择用户角色',
        'role.in'        => '请选择用户角色',
    ];
    
    protected $scene = [
        'add'       =>  ['name','mobile','username','role'],
        'edit'      =>  ['name','mobile','role'],
        'update'    =>  ['name','mobile']
    ];
}