<?php
namespace app\validate\admin;

use think\Validate;

class DemoValidate extends Validate {
    //验证规则
    protected $rule = [
        'name'  =>  'require',
        'min'   =>  'min:1',
        'max'   =>  'max:10',
        'email' =>  'email',
        'number'=>  'number',
        'between'=> 'between:1,10',
        'integer'=> 'integer',
        'float'=>'float',
        'boolean'=>'boolean',
        'array'=>'array',
        'accepted'=>'accepted',
        'date'=>'date',
        'alpha'=>'alpha',//是不是纯字母
        'alphaNum'=>'alphaNum',//验证某个字段的值是否为字母和数字
        'chs'=>'chs',//验证某个字段的值只能是汉字
        'chsAlpha'=>'chsAlpha',//验证某个字段的值只能是汉字、字母
        'chsAlphaNum'=>'chsAlphaNum',//验证某个字段的值只能是汉字、字母和数字
        'activeUrl'=>'activeUrl',//验证某个字段的值是否为有效的域名或者IP
        'url'=>'url',//验证某个字段的值是否为有效的URL地址
        'ip'=>'ip',//验证某个字段的值是否为有效的IP地址
        'dateFormat'=>'dateFormat:y-m-d',//验证某个字段的值是否为指定格式的日期
        'mobile'=>'mobile',//验证某个字段的值是否为有效的手机
        'id_card'=>'idCard',//验证某个字段的值是否为有效的身份证格式
        'in'=>'in:1,2,3',//验证某个字段的值是否在某个范围notIn
        'length'=>'length:4,25',//验证某个字段的值的长度是否在某个范围,只写一个数字表示指定长度
        'after' => 'after:2016-3-18',//验证某个字段的值是否在某个日期之后 before:之前
        'repassword'=>'confirm:password',//验证某个字段是否和另外一个字段的值一致
        'egt'=>'egt:60',//验证是否大于等于某个值 gt:大于；elt：小于等于；lt：小于
    ];

    protected $message  =   [
        'name.require' => '名称必须输入',
        'min.min'     => 'min最少不能低于1个字符',
        'max.max'     => 'max最多不能超过10个字符',
        'number.number'   => 'number必须是数字',
        'email.email'        => '邮箱格式错误',
        'between.between'  => 'between只能在1-120之间',
        'integer.integer'=>'integer不是整数',
        'float.float'=>'float不是浮点数',
        'boolean.boolean'=>'boolean不是浮点值',
        'array.array'=>'array不是数组',
        'accepted.accepted'=>'',//验证某个字段是否为为 yes, on, 或是 1。这在确认"服务条款"是否同意时很有用
        'date.date'=>'date不是日期',
        'alpha.alpha'=>'alpha不是纯字母',
        'alphaNum.alphaNum'=>'alphaNum不是字母或数字',
        'chs.chs'=>'chs不是汉字',
        'chsAlpha.chsAlpha'=>'chsAlpha不是汉字或者字母',
        'chsAlphaNum.chsAlphaNum'=>'chsAlphaNum不是汉字、字母或者数字',
        'activeUrl.activeUrl'=>'activeUrl不是有效的域名或者IP',
        'url.url'=>'url不是有效的URL地址',
        'ip.ip'=>'ip不是有效的ip',
        'dateFormat.dateFormat'=>'dateFormat不是指定格式的日期',
        'mobile.mobile'=>'mobile不是有效的手机',
        'id_card.id_card'=>'id_card不是有效的身份证',
        'in.in'=>'in不在某个范围之内',
        'length.length'=>'length的长度不在某个范围之内',
        'after.after'=>'after在某个时间之后',
        'repassword.confirm'=>'repassword与password不同',
        'egt.egt'=>'egt大于等于某个值',

    ];

    //验证场景
    protected $scene = [
        'edit'  =>  ['name','age'],
    ];

    /**
     * 自定义验证规则
     * @param string $value 验证数据
     * @param string $rule 验证规则
     * @param array $data 全部数据（数组）(可选)
     * @param string $field_name 字段名 (可选)
     * @param string $field_desc 字段描述 (可选)
     * @return string 返回错误信息
     */
    protected function test($value,$rule,$data=[],$field_name='',$field_desc='')
    {
        return '';
    }

}
