<?php

namespace app\common\model\order;
use app\common\model\CommonModel;
use app\common\model\member\MemberModel;
use app\common\model\angling\AnglingModel;
class OrderModel extends CommonModel{
    protected  $name = 'order';
    protected  $pk   = 'order_id';
    protected  $type = [
        'ext_info' => 'array',
        'pay_info' => 'array'
    ];
    
    public function member(){
        return $this->hasOne(MemberModel::class,'member_id','member_id');
    }
    public function angling(){
        return $this->hasOne(AnglingModel::class,'angling_id','angling_id');
    }
    
     public function getRefundTimeFormatAttr($value,$data)
    {
       
        return $data['refund_time'] > 0 ? date('Y-m-d H:i:s',$data['refund_time']) : '-';
    }
     public function getPayTimeFormatAttr($value,$data)
    {
       
        return $data['pay_time'] > 0 ? date('Y-m-d H:i:s',$data['pay_time']) : '-';
    }
}


