<?php

namespace app\common\model\angling;
use app\common\model\CommonModel;
use app\common\model\data\CityModel;
use app\common\model\angling\TuanModel;
class AnglingModel extends CommonModel{
    protected  $name = 'angling';
    protected  $pk   = 'angling_id';
    protected  $type = [
        'photos' => 'array'
    ];
    public function city(){
        return $this->hasOne(CityModel::class,'city_id','city_id');
    }
    public function tuan(){
        return $this->hasMany(TuanModel::class,'angling_id','angling_id');
    }
    public function setFishTypeAttr($value){
        return join(',',$value);
    }
    public function getFishTypeAttr($value){
        $arr = $value ?  explode(',',$value) : [];
        return $arr;
    }
}

