<?php
namespace app\common\logic\setting;
use app\common\model\data\SettingModel;

class SettingLogic {
    
    private $data;
    static private  $obj = null;
    static function getInstance(){
        if(self::$obj === null){
            self::$obj = new SettingLogic();   
        }
        return self::$obj;           
    }
    
    public  function _setData($datas){
        $this->data = $datas;
        return $this;
    }
    
    private function initData(){
        $settings = cache('data-setting');
        if(empty($settings)){
            $datas = SettingModel::select();
            $return = [];
            foreach($datas as $v){
                $return[$v->k] = $v->v;
            }
            cache('data-setting',$return,600);
           return $this->_setData($return);
        }else{
           return $this->_setData($settings);
        }
    }
    
    public function getData(){
        if(empty($this->data)){
            return $this->initData()->data;
        }
        return $this->data;
    }
    
    public function getDataByKey($key){
        $datas = $this->getData();
        return $datas[$key] ?? null;
    }
    
    public function clearCached(){
        cache('data-setting',null);
        return $this;
    }
    
}
