<?php
namespace app\common\logic\order;
use app\common\model\order\OrderModel;
use app\common\model\member\MemberCouponModel;
use app\common\logic\member\IntegralLogic;
use app\common\model\angling\TuanModel;
use app\common\model\market\ExploreModel;
use app\common\model\market\HuodongModel;
class RespondOrderLogic{
    
    static private  $obj = null;
    static function getInstance(){
        if(self::$obj === null){
            self::$obj = new RespondOrderLogic();   
        }
        return self::$obj;           
    }
    
    public function respond($orderId,$payInfo){
        if(null === $order = OrderModel::find($orderId)){
            return false;
        }
        if($order->is_paid == 1){
            return false;
        }
        $order->is_paid = 1;
        $order->pay_time = time();
        $order->pay_info = $payInfo;
        $order->save();
        
        if(!empty($order->coupon_id)){
            MemberCouponModel::where('id',$order->coupon_id)->save([
                'status' => 1
            ]);
        }
        IntegralLogic::getInstance()->addIntegralByOrder($order->need_pay,$order->member_id);
        
        if($order->type == 1){
            TuanModel::where('tuan_id',$order->data_id)->setDec('num',$order->num);
        }
        else if($order->type == 2){
            HuodongModel::where('huodong_id',$order->data_id)->setDec('num',$order->num);
            HuodongModel::where('huodong_id',$order->data_id)->setInc('sold_num',$order->num);
        }else if($order->type == 3){
            ExploreModel::where('explore_id',$order->data_id)->setDec('num',$order->num);
        }
        return  true;
    }
    
 
    
    
}