<?php
namespace app\common\logic\order;
use app\common\model\order\OrderModel;
use app\common\model\member\MemberCouponModel;
use think\Exception;
class CreateOrderLogic {
    private $orderInfo;
    static private  $obj = null;
    static function getInstance(){
        if(self::$obj === null){
            self::$obj = new CreateOrderLogic();   
        }
        return self::$obj;           
    }

    public function create($orderInfo){
        $this->orderInfo = $orderInfo;
        $this->checkCoupon();
        $order = new OrderModel();
        $order->save($this->orderInfo);
        return $order->order_id;
    }
    
    public function checkCoupon(){
        if(empty($this->orderInfo['coupon_id'])) {
            $this->orderInfo['coupon'] = 0;
            return;
        }
        if(null === $coupon = MemberCouponModel::find($this->orderInfo['coupon_id'])){
            $this->err('优惠券不存在');
        }
        if($coupon->member_id != $this->orderInfo['member_id']){
            $this->err('优惠券不存在');
        }
        if($coupon->need_money > $this->orderInfo['total_price']){
            $this->err('该优惠券不可用');
        }
        $today = date('Y-m-d', time());
        if($coupon->bg_time > $today || $coupon->expire_time < $today){
            $this->err('当前优惠券不可用');
        }
        $this->orderInfo['coupon'] = $coupon->money;
        $this->orderInfo['need_pay'] = round(($this->orderInfo['need_pay'] * 100 - $coupon->money * 100)/100,2);
        $this->orderInfo['need_pay'] = $this->orderInfo['need_pay'] < 0 ? 0 :$this->orderInfo['need_pay'];
        return true;
    }
    
    private function err($err){
        throw new Exception($err);
    }
    
}