<?php
namespace app\common\logic\member;
use app\common\model\member\MemberModel;
use app\common\model\member\IntegralModel;
use app\common\logic\setting\SettingLogic;
class IntegralLogic {
    private $setting;
    private $data;
    static private  $obj = null;
    static function getInstance(){
        if(self::$obj === null){
            self::$obj = new IntegralLogic();   
        }
        return self::$obj;           
    }
    
    private function __construct() {
        $this->setting = SettingLogic::getInstance()->getDataByKey('integral');
    }
    
    private  function saveLogs($log,$memberId){
        $logModel = new IntegralModel();
        if(is_array($memberId)){
            $saveAll = [];
            foreach($memberId as $v){
                $log['member_id'] = $v;
                $saveAll[] = $log;
            }
            $logModel->saveAll($saveAll);
        }else{
            $log['member_id'] = $memberId;
            $logModel->save($log);
        }
        return true;
    }
    
    public function addIntegral($memberId,$num,$info){
        if(is_array($memberId)){
            MemberModel::where([
                ['member_id','IN',$memberId]
            ])->inc('integral',$num)->save();  
        }else{
           MemberModel::where('member_id',$memberId)->inc('integral',$num)->save();  
        }
        $this->saveLogs([
            'type' => 1,
            'num'  => $num,
            'info' => $info,
        ], $memberId);
        return true;
    }
    public function useIntegral($memberId,$num,$info){
        MemberModel::where('member_id',$memberId)->dec('integral',$num)->save();
        $this->saveLogs([
            'type' => 2,
            'num'  => $num,
            'info' => $info,
        ], $memberId);
        return true;
    }
    
    public function addIntegralByType($type,$memberId){
        if(!isset($this->setting[$type])) return;
        if(empty($this->setting[$type])) return;
        $typeMeans = [
            'regsiter' => '新用户注册',
            'agent'   => '邀请钓友注册',
            'clock'   => '发钓点打卡记录',
            'rapac'   => '提交野钓资源'
        ];
        if(!isset($typeMeans[$type])) return;
        return $this->addIntegral($memberId, $this->setting[$type], $typeMeans[$type]);   
    }
    public function addIntegralByOrder($money,$memberId){
        if(!isset($this->setting['order'])) return;
        if(empty($this->setting['order'])) return;
        $integral = (int)($money * $this->setting['order']/100);
        if(empty($integral)) return ;
        return $this->addIntegral($memberId, $integral,'订单支付');   
    }
}    
