<?php
namespace app\common\logic\cloud;

use GuzzleHttp\Client;
use app\common\logic\setting\SettingLogic;
class CloudLogic{
    
    protected $auth = '';
    
    //服务端域名不能修改哦
    protected $api = 'https://cloud.uniono2o.com/home/';
    
    protected $client;
    
    protected $params  = [];
    
    public function __construct() {
        $config = SettingLogic::getInstance()->getDataByKey('cloud');
        $this->client = new Client(['base_uri'=> $this->api,'verify' => false,'timeout'  => 30.0]);
        $this->params['token'] = $config  !== null ? $config['code'] : '';
    }
    
    private function getParams($params){
        return array_merge($params, $this->params);
    }
    
    private function error($msg){
        throw new \think\Exception($msg);
    }
    
    public function download($api,$params,$file){
  
        $response = $this->client->post($api,['sink'=>$file,'query'=> $this->getParams($params)]);
        if(file_exists($file)){

            return true;
        }
        return false;
    }


    public function request($api,$params = [],$auth = true){
        $response = $this->client->request('POST',$api,[
           'query'=>$auth == true ?  $this->getParams($params) : $params, 
        ]);
   
        $data = json_decode($response->getBody(), true);
        if($data['code'] == 200){
            return $data['data'];
        } else {
            $this->error($data['msg']);
        }
    }

   
    
}