<?php
namespace app\common\helper\sms;
use app\common\logic\setting\SettingLogic;
use app\common\helper\sms\AliyunSmsHelper;
use app\common\helper\sms\QcloudSmsHelper;
use app\common\helper\sms\QiniuSmsHelper;
class SmsHelper {
    
    static function sendCode($mobile,$code){
        $sms = SettingLogic::getInstance()->getDataByKey('sms');
        if(empty($sms) || empty($sms['code'])){
            return false;
        }
        return self::sendSms($sms['code'], [$mobile], [
            'code' => $code
        ]);
    }
    
    static function sendSms($smsId, array $mobile,$params){
        static $obj = null;
        if($obj === null){
            $config = SettingLogic::getInstance()->getDataByKey('sms');
            if(empty($config)){
                return  false;
            }
            switch ($config['type']){
                case 1:
                    $obj = new QiniuSmsHelper($config['qiniu']);
                    break;
                case 2:
                    $obj = new AliyunSmsHelper($config['ali']);
                    break;
                default:
                    $obj = new QcloudSmsHelper($config['qcloud']);
                    break;
            }
        }
        return $obj->sendSms($smsId,$mobile,$params);    
    }
    
    
}