<?php
namespace app\common\helper\sms;

use TencentCloud\Sms\V20210111\SmsClient;
use TencentCloud\Sms\V20210111\Models\SendSmsRequest;
use TencentCloud\Common\Exception\TencentCloudSDKException;
use TencentCloud\Common\Credential;
use TencentCloud\Common\Profile\ClientProfile;
use TencentCloud\Common\Profile\HttpProfile;

class QcloudSmsHelper{
    
    private $config;
    public function __construct($config) {
        $this->config = $config;
    }
    
    /**
     * 发送短信的
     * @param smsId 模版ID
     */
    public function sendSms($smsId,$mobiles,$params){
      
        try {
            /* 必要步骤：
             * 实例化一个认证对象，入参需要传入腾讯云账户密钥对 secretId 和 secretKey
             * 本示例采用从环境变量读取的方式，需要预先在环境变量中设置这两个值
             * 您也可以直接在代码中写入密钥对，但需谨防泄露，不要将代码复制、上传或者分享给他人
             * CAM 密钥查询：https://console.cloud.tencent.com/cam/capi
             */
            $cred = new Credential(trim($this->config['secret_id']), trim($this->config['secret_key']));
            $httpProfile = new HttpProfile();
            $httpProfile->setReqMethod("GET");  // POST 请求（默认为 POST 请求）
            $httpProfile->setReqTimeout(30);    // 请求超时时间，单位为秒（默认60秒）
            $httpProfile->setEndpoint("sms.tencentcloudapi.com");  // 指定接入地域域名（默认就近接入）
             // 实例化一个 client 选项，可选，无特殊需求时可以跳过
            $clientProfile = new ClientProfile();
            $clientProfile->setSignMethod("TC3-HMAC-SHA256");  // 指定签名算法（默认为 HmacSHA256）
            $clientProfile->setHttpProfile($httpProfile);
             // 实例化 SMS 的 client 对象，clientProfile 是可选的
            $client = new SmsClient($cred, "ap-shanghai", $clientProfile);
             // 实例化一个 sms 发送短信请求对象，每个接口都会对应一个 request 对象。
            $req = new SendSmsRequest();
             /* 填充请求参数，这里 request 对象的成员变量即对应接口的入参
             * 您可以通过官网接口文档或跳转到 request 对象的定义处查看请求参数的定义
             * 基本类型的设置:
               * 帮助链接：
               * 短信控制台：https://console.cloud.tencent.com/smsv2
               * sms helper：https://cloud.tencent.com/document/product/382/3773 */
             /* 短信应用 ID: 在 [短信控制台] 添加应用后生成的实际 SDKAppID，例如1400006666 */
            $req->SmsSdkAppid = trim($this->config['app_id']);
            /* 短信签名内容: 使用 UTF-8 编码，必须填写已审核通过的签名，可登录 [短信控制台] 查看签名信息 */
            $req->Sign = $this->config['bucket'];
            
            /* 下发手机号码，采用 e.164 标准，+[国家或地区码][手机号]
            * 例如+8613711112222， 其中前面有一个+号 ，86为国家码，13711112222为手机号，最多不要超过200个手机号*/
            
            foreach($mobiles as $k=>$val){
                $mobiles[$k] = '+86'.$val;
            }
            
            $req->PhoneNumberSet = $mobiles;
            $req->TemplateID = $smsId;
            /* 模板参数: 若无模板参数，则设置为空*/
            $req->TemplateParamSet = array_values($params);
              // 通过 client 对象调用 SendSms 方法发起请求。注意请求方法名与请求对象是对应的
            $resp = $client->SendSms($req);
            return true;
          }
          catch(TencentCloudSDKException $e) {
             return false;
          }
    }
    
}
