<?php
namespace app\common\helper\sms;

use AlibabaCloud\Client\AlibabaCloud;

class AliyunSmsHelper{
    private $config;
    public function __construct($config) {
        $this->config = $config;
    }
    
    /**
     * 发送短信的
     * @param smsId 模版ID
     */
    public function sendSms($smsId,$mobiles,$params){
        AlibabaCloud::accessKeyClient(trim($this->config['access_key_id']), trim($this->config['access_key_secret']))
                        ->regionId('cn-hangzhou')
                        ->asDefaultClient();
        
        $result = AlibabaCloud::rpc()
                          ->product('Dysmsapi')
                         ->version('2017-05-25')
                          ->action('SendSms')
                          ->method('POST')
                          ->host('dysmsapi.aliyuncs.com')
                          ->options([
                                        'query' => [
                                          'PhoneNumbers' => join(',',$mobiles),
                                          'SignName' => trim($this->config['sign']),
                                          'TemplateCode' => $smsId,
                                          'TemplateParam' => json_encode($params)
                                        ],
                                    ])
                          ->request();
        return true;
    }
    
}