<?php
namespace app\common\helper\oss;
use Qiniu\Auth;
use Qiniu\Storage\UploadManager;
use think\Exception;
class QiniuOssHelper {
    private $config;
    private $url;
    public function __construct($config) {
        $this->config = $config;
        $this->url = rtrim($config['domain'],'\/');
    }
    
    private function getDir(){
        return date('Ymd',time());
    }
    public function getUrl(){
        return $this->url;
    }
    public function upload($file,$name){
        $auth = new Auth(trim($this->config['qiniu']['ak']), trim($this->config['qiniu']['sk']));
        $token = $auth->uploadToken(trim($this->config['qiniu']['bucket']));
        $filePath = $file['tmp_name'];
        $object = $this->getDir().'/'.$name;
        $uploadMgr = new UploadManager();
        list($ret, $err) = $uploadMgr->putFile($token, $object, $filePath);
        if($err !== null){
            throw new Exception('上传七牛云失败');
        }
        return  [
            'url'   => $this->url.'/'.$ret['key'],
            'hash'  =>  md5_file($file['tmp_name']),
            'key'   => $ret['key'],
        ];
    }
}