<?php
namespace app\common\helper\oss;
use Qcloud\Cos\Client;
class   QcloudOssHelper {
    
    
    private $config;
    private $url;
    public function __construct($config) {
        $this->config = $config;
        $this->url = rtrim($config['domain'], '\/');
    }
   
    private function getDir(){
         return date('Ymd',time());
    }
    public function getUrl(){
        return $this->url;
    }
    public function upload($file, $name) {
        $secretId = trim($this->config['qcloud']['secret_id']); //"云 API 密钥 SecretId";
        $secretKey = trim($this->config['qcloud']['secret_key']); //"云 API 密钥 SecretKey";
        $region = trim($this->config['qcloud']['region']); //设置一个默认的存储桶地域
        $key = $this->getDir().'/'.$name; //增加一个日期目录
        $cosClient = new Client([
            'region' => $region,
            'schema' => 'https', //协议头部，默认为http
            'credentials' => [
                'secretId' => $secretId,
                'secretKey' => $secretKey
            ]
        ]);
        $result = $cosClient->putObject([
            'Bucket' => trim($this->config['qcloud']['bucket']), //格式：BucketName-APPID 
            'Key' => $key,
            'Body' => fopen($file['tmp_name'], 'rb'),
        ]);
        return [
            'url' => $this->url . '/' . $key,
            'key' => $key,
            'hash' => md5_file($file['tmp_name']), //其实应该md5 file的
        ];
    }
}