<?php
namespace app\common\helper\oss;
use app\common\helper\oss\AliyunOssHelper;
use app\common\helper\oss\LocalOssHelper;
use app\common\helper\oss\QcloudOssHelper;
use app\common\helper\oss\QiniuOssHelper;
use app\common\logic\setting\SettingLogic;
use think\Exception;
class OssHelper{
    private $uploadHandler;
    private $type;    
    private $unlink;
    public function __construct() {
        $config = SettingLogic::getInstance()->getDataByKey('oss');
        $this->type =  (int) $config['type'];
        switch ($this->type){
            case 1:
                $this->uploadHandler = new QiniuOssHelper($config);
                break;
            case 2:
                $this->uploadHandler = new AliyunOssHelper($config);
                break;
            case 3:
                $this->uploadHandler = new QcloudOssHelper($config);
                break;
            default:
                $this->uploadHandler = new LocalOssHelper();
                break;
        }
     
    }
    
    public function getType(){
        return $this->type;
    }
    
    public function getUrl(){
        return $this->uploadHandler->getUrl();
    }

    
    public function upload($file){
        if(empty($file)){
            throw new Exception('请上传图片');
        }
        $file_name = $file['name'];//获取缓存区图片,格式不能变
        $type = array("jpg","jpeg", "gif", 'png', 'bmp');//允许选择的图片类型
        $ext = explode(".", $file_name);//拆分获取图片名
        $ext = strtolower($ext[count($ext) - 1]);
        if (!in_array($ext,$type)){
            throw new Exception('图片上传不合法');
        } 
        $size = filesize($file['tmp_name']);
        $name = md5(uniqid(true)).time().'.'.$ext;
        $this->unlink[] = $file['tmp_name'];
        $res = $this->uploadHandler->upload($file,$name);
        $res['size'] = $size;
        $res['ext'] = $ext;
        return $res;
    }
    
    public function __destruct() { //析构对未完成上传的文件清除
        if(!empty($this->unlink)){
            foreach($this->unlink as $val){
                if(file_exists($val)){
                    unlink($val);
                } 
            }
        }
    }
    
}