<?php
namespace app\common\helper\oss;
use think\Exception;
class LocalOssHelper {
    
    private $url;
    public function __construct() {
        $this->url =  rtrim(env('base_url'),'\/');
    }
    
    public function getUrl(){
        return $this->url;
    }
    
 
    private function getDir(){
         return date('Ymd',time());
    }
    
    public function upload($file,$name){
        
        $date = $this->getDir();
        $dir = root_path().'/public/oss/'.$date;
        if(!is_dir($dir)){
            mkdir($dir,0755,true);
        }
        $fullname = $dir.'/'.$name;
        if(file_exists($fullname)){
            throw new Exception('文件已经存在');
        }
        move_uploaded_file($file['tmp_name'], $fullname);
        return [
            'url'   => $this->url . '/oss/'.$date.'/'.$name,
            'key'   => $name,
            'hash'  =>  md5($file['tmp_name']), 
        ];
    }
}