<?php
namespace app\common\helper\oss;
use OSS\OssClient;
class AliyunOssHelper {
    
    private $config;
    private $url;
   
    public function __construct($config) {
        $this->config = $config;
        $this->url = rtrim($config['domain'],'\/');
    }
   
    private function getDir(){
        return date('Ymd',time());
    }
    
    public function getUrl(){
        return $this->url;
    }
    public function upload($file,$name){
        $accessKeyId = trim($this->config['ali']['access_key_id']);
        $accessKeySecret = trim($this->config['ali']['access_key_secret']);
        // Endpoint以杭州为例，其它Region请按实际情况填写。
        $endpoint = trim($this->config['ali']['endpoint']);
        // 设置存储空间名称。
        $bucket=  trim($this->config['ali']['bucket']);
        // 设置文件名称。
        $object = $this->getDir().'/'.$name;
        // <yourLocalFile>由本地文件路径加文件名包括后缀组成，例如/users/local/myfile.txt。
        $filePath = $file['tmp_name'];
        $ossClient = new OssClient($accessKeyId, $accessKeySecret, $endpoint);
        $ossClient->uploadFile($bucket, $object, $filePath);        
        return [
            'url'   => $this->url . '/'.$object,
            'key'   => $object,
            'hash'  =>  md5_file($file['tmp_name']), //其实应该md5 file的
        ];
    }
    
}