<?php
namespace app\common\helper\mp;
use app\common\logic\setting\SettingLogic;
use EasyWeChat\Pay\Application;
use app\common\model\mp\PaymentModel;
use EasyWeChat\Pay\Message;
class PaymentHelper {
    
    protected $appId;
    protected $app;
    protected $mchId;
    public function __construct() {
        $mp = SettingLogic::getInstance()->getDataByKey('mp');
        $path = $this->getCertDir();
        $certFile = $path . md5($mp['api_cert']) . '_cert.perm';
        if (!file_exists($certFile)) {
            file_put_contents($certFile, $mp['api_cert']);
        }
        $keyFile = $path . md5($mp['api_key']) . '_key.perm';
        if (!file_exists($keyFile)) {
            file_put_contents($keyFile, $mp['api_key']);
        }
        $this->appId = $mp['app_id'];
        $this->mchId = $mp['mach_id'];
        $config = [
            'mch_id' => $mp['mach_id'],
            // 商户证书
            'private_key' => $keyFile,
            'certificate' => $certFile,
            // v3 API 秘钥
            'secret_key' => $mp['api_auth'],
            'http' => [
                'throw' => true, // 状态码非 200、300 时是否抛出异常，默认为开启
                'timeout' => 10.0,
            ],
        ];
        $this->app = new Application($config);
    }
    
    protected function getBackUrl(){ //返回支付回调URL
        return env('base_url', 'https://pin.pinyuyu.com/').'mp/respond';
    }
    
 public function batches($data){
        $app = $this->app;
        $params = [
            'appid'        => $this->appId,
            'out_batch_no' => $data['id'],
            'batch_name'   => $data['title'],
            'batch_remark' => $data['info'],
            'total_amount' => $data['money'],
            'total_num'    => $data['total'],
            'transfer_detail_list' => [
                
            ]
        ];
        $i = 0;
        foreach($data['list'] as $val){
            $i++;
            $params['transfer_detail_list'][] =[
                'out_detail_no' => $data['id'].'c'.$i,
                'transfer_amount' =>  $val['money'],
                'transfer_remark' => $data['info'],
                'openid' => $val['open_id'],
            ]; 
        }
        try{
            $app->getClient()->postJson('/v3/transfer/batches',$params);
        } catch (Exception $e){
            echo $e->getMessage();
        }
        return true;
    }
    public function getPayment($order) {
        if(empty($order['product_name']) || empty($order['order_id']) || empty($order['need_pay']) || empty($order['open_id'])){
            return false;
        }
        $app = $this->app;
        $response = $app->getClient()->postJson("v3/pay/transactions/jsapi", [
            "mchid" => $this->mchId, // <---- 请修改为您的商户号
            "out_trade_no" => 'mp_'.$order['order_id'],
            "appid" => $this->appId, 
            "description" => $order['product_name'],
            "notify_url" => $this->getBackUrl(),
            "amount" => [
                 "total" =>(int)($order['need_pay'] * 100),
                 "currency" => "CNY"
             ],
             "payer" => [
                 "openid" => $order['open_id']
             ]
         ]);
  
        $res = $response->toArray(false);
        if(empty($res['prepay_id'])){
           return false; 
        }
        $utils = $app->getUtils();
        return $utils->buildBridgeConfig($res['prepay_id'], $this->appId, 'RSA'); // 返回数组        
    }
    
    //退款
    public function refund($payInfo,$money = 0){
        $app = $this->app;
        $refundMoney = $money > 0 ? (int)($money * 100)  :  $payInfo['amount']['payer_total'];
        return $app->getClient()->postJson('/v3/refund/domestic/refunds',[
            'out_trade_no' => $payInfo['out_trade_no'],
            'out_refund_no' => $payInfo['out_trade_no'],
            'amount'        => [
                'refund' => $refundMoney,
                'total'  => $payInfo['amount']['payer_total'],
                'currency' =>'CNY'
            ]
        ]);
    }
    
    
    public function respond() {
        $server = $this->app->getServer();
        $app = $this->app;
        $server->handlePaid(function (Message $message, \Closure $next) use($app){
            // $message->out_trade_no 获取商户订单号
            // $message->payer['openid'] 获取支付者 openid
            $outTradeNo = $message->out_trade_no;
            $response = $app->getClient()->get("v3/pay/transactions/out-trade-no/{$outTradeNo}", [
                'query'=>[
                    'mchid' => $this->mchId
                ]
            ]);
            $res = $response->toArray(false);
            //查询结果正确后 处理后面逻辑
            if(!empty($res['trade_state']) && $res['trade_state'] == 'SUCCESS'){ //操作下一步
                $orderNum = explode('_', $message->out_trade_no);
                $id = (int)$orderNum[1];
                if(null !== $pay = PaymentModel::find($id)){
                    if($pay->is_paid == 0){
                        $pay->is_paid = 1;
                        $pay->save();
                        
                    }
                }
            }
            return $next($message);
        });
        return $server->serve();
    }

    protected function getCertDir() {
        $dir = root_path() . '/cert/';
        if (!is_dir($dir)) {
            mkdir($dir, 0755, true);
        }
        return $dir;
    }

}
