<?php

namespace app\common\helper\mp;

use app\common\model\data\MpTemplateModel;
use app\common\helper\mp\MpHelper;

class MpTemplateHelper {

    //需要更新设置的ID
    private $temp = [
        'tongji' => 'OPENTM401155654',
        'order' => 'OPENTM401973756',
        'expire' => 'OPENTM411626253'
    ];
    private $datas = [];
    static private $obj = null;

    static function getInstance() {
        if (self::$obj === null) {
            self::$obj = new MpTemplateHelper();
        }
        return self::$obj;
    }

    public function setDatas(){
        $datas = MpTemplateModel::select()->toArray();
        $this->datas = $datas;
        return $this;
    }

    public function getDatas() {
        return $this->datas;
    }

    private function getHas() {
        $tempIds = [];
        foreach ($this->datas as $val) {
            $tempIds[] = $val['template'];
        }
        return $tempIds;
    }

    private function getTemplateIds() {
        $tempIds = [];
        foreach ($this->datas as $val) {
            $tempIds[$val['template']] = $val['template_id'];
        }
        return $tempIds;
    }

    private function getTemplates() {
        $tempIds = [];
        foreach ($this->datas as $val) {
            $tempIds[$val['template_id']] = $val;
        }
        return $tempIds;
    }
    
    public function deleteTemplate($id){
        if(empty($id)) return false;
        if(null === $temp = MpTemplateModel::find($id)){
            return false;
        }
        if(!empty($temp->template_id)){
            MpHelper::getInstance()->deleteTemplate($temp->template_id);
        }
        $temp->delete();
        return true;
    }
    
    public function getPrivateTemplates() {
        $tempIds = $this->setDatas()->getTemplates();
        $templates = MpHelper::getInstance()->getPrivateTemplates();
        $return = [];
        foreach ($templates['template_list'] as $val) {
            if (isset($tempIds[$val['template_id']])) {
                $return[] = [
                    'id' => $tempIds[$val['template_id']]['id'],
                    'template' => $tempIds[$val['template_id']]['template'],
                    'template_id' => $val['template_id'],
                    'title' => $val['title'],
                    'primary_industry' => $val['primary_industry'],
                    'deputy_industry' => $val['deputy_industry'],
                ];
            }
        }
        $this->datas = $return;
        if(!empty($return)){
            $MpTemplateModel = new MpTemplateModel();
            $MpTemplateModel->saveAll($return);
        }
        return $this;
    }

    public function setTempalte() {
        $tempIds = $this->setDatas()->getHas();
        foreach ($this->temp as $val) {
            if (!in_array($val, $tempIds)) {
                $res = MpHelper::getInstance()->setTemplate($val);
                if ($res['errmsg'] == 'ok') {
                    $this->saveData($val, $res['template_id']);
                }
            }
        }
        return $this;
    }

    private function saveData($template, $templateId) {
        $MpTemplateModel = new MpTemplateModel();
        $MpTemplateModel->save([
            'template' => $template,
            'template_id' => $templateId
        ]);
    }

}
