<?php
namespace app\common\helper\mp;
use app\common\logic\setting\SettingLogic;
use EasyWeChat\OfficialAccount\Application;
use app\common\model\mp\KeywordModel;
class MpHelper{
    private  $app;
    static private  $obj = null;
    static function getInstance(){
        if(self::$obj === null){
            self::$obj = new MpHelper();   
        }
        return self::$obj;           
    }
    private  function __construct() {
       $mp = SettingLogic::getInstance()->getDataByKey('mp');
       $config = [
            'app_id'    => trim($mp['app_id']),
            'secret'    => trim($mp['secret']),
            'token'     => trim($mp['token']),
            'aes_key'   => trim($mp['aes_key']),
        ];
        $this->app = new Application($config);
    }
    
    public function buildConfig($apis,$url){
        $utils = $this->app->getUtils();
        return $utils->buildJsSdkConfig( $url, $apis);
    }
    
    public function getAuthUrl($backUrl){
        return $this->app->getOauth()->redirect($backUrl);
    }
    
    public function getUserInfo($code){
        $user  = $this->app->getOAuth()->userFromCode($code);
        return $user->getId();
    }
    
    public function setTemplate($tempId){
        $api = $this->app->getClient();
        return $api->postJson('cgi-bin/template/api_add_template',[
            'template_id_short' => $tempId
        ]);
    }
    
    public function getPrivateTemplates(){
        $api = $this->app->getClient();
        return $api->get('cgi-bin/template/get_all_private_template');
    }
    public function deleteTemplate($templateId){
        $api = $this->app->getClient();
        return $api->postJson('cgi-bin/template/del_private_template',[
            'template_id'=> $templateId
        ]);
    }
    
    public function  getQrcode($code){
        $api = $this->app->getClient();
        return $api->postJson('cgi-bin/qrcode/create',[
            'expire_seconds' => 3600,
            'action_name'=> 'QR_STR_SCENE',
            'action_info' => ['scene_str'=>$code],
        ]);
    }
  


    public function saveMenu($buttons)
    {   
        $api = $this->app->getClient();
        return $api->postJson('cgi-bin/menu/create',[
            'button' => $buttons
        ]);
    }
    
    
    public function serve(){
        $app = $this->app;
        $that = $this;
        $server = $app->getServer();
        $server->with(function($message, \Closure $next) use($that) {
            switch ($message['MsgType']){
                case 'event':
                    if($message['Event'] == 'CLICK' && !empty($message['EventKey'])){
                        return $that->keywrodByClick($message['EventKey']);
                     }
                    break;
                case 'text':
                    return $that->text($message['Content']);
                    break;
            }
            return $next($message);
        });
       return  $server->serve();
    }
    public function text($keyword){
        if(empty($keyword)){
            return '';
        }
        if(null === $data = KeywordModel::where('keyword',$keyword)->find()){
            return '';
        }
        return $this->returnKeywordContent($data);
    }
    private  function keywrodByClick($id){
        $key = str_replace('kwd_', '', $id);
        $key = (int) $key;
        if(empty($key)){
            return '';
        }
        if(null === $data = KeywordModel::find($key)){
            return '';
        }
        return $this->returnKeywordContent($data);
    }
    private function returnKeywordContent($data){
        switch ($data->type){
            case 'text':
                return [
                    'MsgType' => 'text',
                   'Content' => $data->content,  
                ];
                break;
            case 'news':
                    return [
                        'MsgType' => 'news',
                        'ArticleCount' => 1,
                        'Articles' => [
                                [
                                    'Title' => $data->title,
                                    'Description' => $data->desc,
                                    'Url'   =>$data->url,
                                    'PicUrl' => $data->photo
                                ]
                            ]
                       ]
                    ;
                break;
        }
        return  '';
    }

    
}