<?php
namespace app\common\helper\miniapp;
use app\common\logic\setting\SettingLogic;
use EasyWeChat\MiniApp\Application;
class MiniappHelper {
    private $app;
    static private  $obj = null;
    static function getInstance(){
        if(self::$obj === null){
            self::$obj = new MiniappHelper();   
        }
        return self::$obj;           
    }
    
    private  function __construct() {
       $settting = SettingLogic::getInstance()->getDataByKey('miniapp');
       $config = [
            'app_id'  =>  empty($settting['app_id']) ? '' : trim($settting['app_id']),
            'secret'  =>  empty($settting['app_secret']) ? '' : trim($settting['app_secret']),
        ];
        $this->app =  new Application($config);
    }
    

    //数量较少的二维码
    public function qrcode($path,$params = []){
        $api = $this->app->getClient();
       return $api->postJson('wxa/getwxacode',[
           'path' => $path,
       ]);
    }

    
    //数量较多的二维码路径不能带参数
    public function getUnlimit($scene,$path){
        $api = $this->app->getClient();
        return $api->postJson('wxa/getwxacodeunlimit',[
            'scene' => $scene,
            'page' => $path
        ]);
    }
    
    public  function getOpenId($code){
        $return = [];
        if(empty($code)){
            return false;
        }
        $utils  = $this->app->getUtils();
        $session = $utils->codeToSession($code); //用CODE 换session_key
        if(empty($session['session_key']) && empty($session['openid'])){
            return false;
        }
        return $session['openid'];
    }
    public function getMobile($code){
        $return = [];
        if(empty($code)){
            return false;
        }
        $api = $this->app->getClient();
        $res = $api->postJson('wxa/business/getuserphonenumber',[
            'code' => $code
        ]);
        if(empty($res['phone_info'])){
            return false;
        }
        return $res['phone_info']['purePhoneNumber'];
    }
    
}