<?php
// 应用公共文件

// 应用公共文件
function doMoveDir($source, $target) {

    if (!is_dir($target)) {
        if (!mkdir($target,0755,true)) {
            return false;
        }
    }
    $d = dir($source);
    while (($entry = $d->read()) !== false) {
        if (is_dir($source . $entry)) {
            if ($entry == "." || $entry == "..") {
                continue;
            } else {
                doMoveDir($source . $entry . '/', $target . $entry . '/');
            }
        } else {
            if (!copy($source . $entry, $target . $entry)) {
                return false;
            }
        }
    }
    return true;
}

function wyuLog($file,$str){
    $file = root_path().$file;
    $fp = fopen($file,'a+');
    fwrite($fp, $str."\n");
    fclose($fp);
}



function checkDateFormat($date)
{
    //匹配日期格式
    if (preg_match("/^([0-9]{4})-([0-9]{2})-([0-9]{2})$/", $date, $parts)) {
        //检测是否为日期
        if (checkdate($parts[2], $parts[3], $parts[1]))
            return true;
        else
            return false;
    } else
        return false;
}

//将一个数组的主键作为KEY
function array_by_key($data, $key = 'id')
{
    $return = [];
    foreach ($data as $val) {
        $return[$val[$key]] = $val;
    }
    return $return;
}



/**
 * 判断输入的字符串是否是一个合法的电话号码（仅限中国大陆）
 * @param string $string
 * @return boolean
 */
function is_phone($string)
{
  
    return preg_match('/^[0,4,8]\d{2,3}-\d{7,8}$/', $string);
}

/**
 * 验证手机号
 */
function is_mobile($string)
{
    return preg_match('/^1[345789]\d{9}$/', $string);
}

//获取安全的JSON 或数组
function security_json_or_array($str)
{
    if (is_array($str)) {
        $datas = $str;
    } else {
        $datas = json_decode($str, true);
        if (json_last_error() != JSON_ERROR_NONE) {
            return [];
        }
    }
    if (empty($datas)) return [];
    $return = [];
    foreach ($datas as $key => $val) {
        if (is_array($val)) {
            $return[$key] = security_json_or_array($val);
        } else {
            $return[$key] = security_editor_textarea($val);
        }
    }
    return $return;
}

//获取安全的textarea
function security_editor_textarea($str)
{
    $farr = [
       // "/\s+/", //过滤多余的空白
        "/<(\/?)(script|i?frame|style|html|body|title|link|meta|\?|\%)([^>]*?)>/isU",
        "/(<[^>]*)on[a-zA-Z]+\s*=([^>]*>)/isU"
    ];
    $tarr = [
      //  " ",
        "＜\\1\\2\\3＞",
        "\\1\\2",
    ];
    $str = preg_replace($farr, $tarr, $str);

    return $str;
}

//获取安全的HTML
function security_editor_html($str)
{
    $str = security_editor_textarea($str);
    $str = str_replace(["\\r\\n", "\\r", "\\n"], "", $str);
    return $str;
}

//加解密函数

function auth_code($string, $operation = 'ENCODE', $key = '', $expiry = 0)
{
    // 动态密匙长度，相同的明文会生成不同密文就是依靠动态密匙
    $ckey_length = 4;
    // 密匙
    $key = md5($key ? $key : config('auth.code'));
    // 密匙a会参与加解密
    $keya = md5(substr($key, 0, 16));
    // 密匙b会用来做数据完整性验证
    $keyb = md5(substr($key, 16, 16));
    // 密匙c用于变化生成的密文
    $keyc = $ckey_length ? ($operation == 'DECODE' ? substr($string, 0, $ckey_length) :
        substr(md5(microtime()), -$ckey_length)) : '';
    // 参与运算的密匙
    $cryptkey = $keya . md5($keya . $keyc);
    $key_length = strlen($cryptkey);
    // 明文，前10位用来保存时间戳，解密时验证数据有效性，10到26位用来保存$keyb(密匙b)，
//解密时会通过这个密匙验证数据完整性
    // 如果是解码的话，会从第$ckey_length位开始，因为密文前$ckey_length位保存 动态密匙，以保证解密正确
    $string = $operation == 'DECODE' ? base64_decode(substr($string, $ckey_length)) :
        sprintf('%010d', $expiry ? $expiry + time() : 0) . substr(md5($string . $keyb), 0, 16) . $string;
    $string_length = strlen($string);
    $result = '';
    $box = range(0, 255);
    $rndkey = array();
    // 产生密匙簿
    for ($i = 0; $i <= 255; $i++) {
        $rndkey[$i] = ord($cryptkey[$i % $key_length]);
    }
    // 用固定的算法，打乱密匙簿，增加随机性，好像很复杂，实际上对并不会增加密文的强度
    for ($j = $i = 0; $i < 256; $i++) {
        $j = ($j + $box[$i] + $rndkey[$i]) % 256;
        $tmp = $box[$i];
        $box[$i] = $box[$j];
        $box[$j] = $tmp;
    }
    // 核心加解密部分
    for ($a = $j = $i = 0; $i < $string_length; $i++) {
        $a = ($a + 1) % 256;
        $j = ($j + $box[$a]) % 256;
        $tmp = $box[$a];
        $box[$a] = $box[$j];
        $box[$j] = $tmp;
        // 从密匙簿得出密匙进行异或，再转成字符
        $result .= chr(ord($string[$i]) ^ ($box[($box[$a] + $box[$j]) % 256]));
    }
    if ($operation == 'DECODE') {
        // 验证数据有效性，请看未加密明文的格式
        if ((substr($result, 0, 10) == 0 || substr($result, 0, 10) - time() > 0) &&
            substr($result, 10, 16) == substr(md5(substr($result, 26) . $keyb), 0, 16)
        ) {
            return substr($result, 26);
        } else {
            return '';
        }
    } else {
        // 把动态密匙保存在密文里，这也是为什么同样的明文，生产不同密文后能解密的原因
        // 因为加密后的密文可能是一些特殊字符，复制过程可能会丢失，所以用base64编码
        return $keyc . str_replace('=', '', base64_encode($result));
    }
    //替换url包成url参数唯一性；
}


/**
 * 隐藏手机号中间四位
 * @param $str
 * @return string|string[]
 */
function yc_phone($str){
    if(is_mobile($str)){
        $str=substr_replace($str,'****',3,4);
    }
    return $str;
}


