<?php

use think\facade\Route;

//不需要登陆的
Route::group(function (){
    Route::rule('init','index/init'); 
    Route::rule('login','login/login'); 
    Route::rule('bindMobile','login/bindMobile');
    
    Route::rule('getHomeDatas','index/getHomeDatas'); 
    
    
    Route::rule('getRapacList','rapac/index'); 
    Route::rule('getRapacDetail','rapac/detail'); 
    
    Route::rule('getClockList','clock/index'); 
    Route::rule('getClockDetail','clock/detail'); 
    Route::rule('getClockAddr','clock/clockAddr'); 
    
    Route::rule('getAnglingList','angling/index'); 
    Route::rule('getAnglingDetail','angling/detail'); 
    
    Route::rule('getHuodongList','huodong/index'); 
    Route::rule('getHuodongDetail','huodong/detail'); 
    Route::rule('getExploreList','explore/index'); 
    Route::rule('getExploreDetail','explore/detail'); 
    
    Route::rule('createTeamOrder','index/teamOrder'); 
    
    
    //获取优惠券列表非登陆状态
    Route::rule('getCouponListNoLogin','coupon/getCouponList'); 
    Route::rule('getExchangeCouponList','coupon/getExchangeCouponList'); 
    
    //获取领鱼饵的列表
    Route::rule('getLotteryList','lottery/index'); 
    Route::rule('getLotteryDetailNoLogin','lottery/detail'); 
    Route::rule('getLotteryJoinList','lottery/getJoinList'); 
    
    
    //订单支付回调
    Route::rule('orderPayRespond','order/payRespond'); 
});

//需要登陆的
Route::group(function (){
    
    Route::rule('getExploreLoginList','explore/index'); 
    Route::rule('getExploreLoginDetail','explore/detail'); 
    
    Route::rule('upload','upload/upload');
    Route::rule('saveNickInfo','login/nickInfo');
    Route::rule('changeMobile','login/changeMobile');
    
    
    Route::rule('addRapacData','rapac/add');
    Route::rule('addClockData','clock/add');
 
    
    Route::rule('getMyClockList','clock/myList');
    
    Route::rule('getMyIntegralList','member/integral');
    Route::rule('getMemberCount','member/getMemberCount');
    
    
    //优惠券
    Route::rule('getCouponListLogin','coupon/getCouponList'); 
    Route::rule('getMyCouponList','coupon/getMyCouponList');
    Route::rule('receiveCoupon','coupon/receiveCoupon');
    Route::rule('exchangeCoupon','coupon/exchangeCoupon');
    
    Route::rule('getLotteryDetailLogin','lottery/detail'); 
    Route::rule('joinLottery','lottery/joinAct'); 
    
    
    //订单
    Route::rule('getOrderPay','order/getOrderPay'); 
    Route::rule('applyOrderRefund','order/applyRefund'); 
    Route::rule('cancelOrder','order/cancelOrder'); 
    Route::rule('getOrderList','order/getOrderList'); 
    Route::rule('getOrderDetail','order/getOrderDetail'); 
    Route::rule('createTuanOrder','order/createTuanOrder'); 
    Route::rule('createExploreOrder','order/createExploreOrder'); 
    Route::rule('createHuodongOrder','order/createHuodongOrder'); 
    
    Route::rule('manage/init','manage.index/index');
    Route::rule('manage/applyAngling','manage.index/apply');
    
    
    
})->middleware(\app\api\middleware\MemberCheck::class);

//商家管理中心的操作需要
Route::group(function (){
    Route::rule('manage/getTuanList','manage.tuan/index');
    Route::rule('manage/getTuanDetail','manage.tuan/detail');
    Route::rule('manage/delTuan','manage.tuan/del');
    Route::rule('manage/saveTuan','manage.tuan/save');
    
    Route::rule('manage/getHuodongList','manage.huodong/index');
    Route::rule('manage/getHuodongDetail','manage.huodong/detail');
    Route::rule('manage/delHuodong','manage.huodong/del');
    Route::rule('manage/saveHuodong','manage.huodong/save');
    Route::rule('manage/changeHuodong','manage.huodong/changeStatus');
    
    Route::rule('manage/getExploreList','manage.explore/index');
    Route::rule('manage/getExploreDetail','manage.explore/detail');
    Route::rule('manage/delExplore','manage.explore/del');
    Route::rule('manage/saveExplore','manage.explore/save');
    Route::rule('manage/changeExplore','manage.explore/changeStatus');
    
    
    Route::rule('manage/getVipList','manage.vip/getVipList');
    Route::rule('manage/addVipMoney','manage.vip/addVipMoney');
    Route::rule('manage/useVipMoney','manage.vip/useVipMoney');
    Route::rule('manage/getVipProjects','manage.vip/getVipProjects');
    Route::rule('manage/useVipProject','manage.vip/useVipProject');
    Route::rule('manage/addVipProject','manage.vip/addVipProject');
    Route::rule('manage/getVipProjectLogs','manage.vip/getVipProjectLogs');
    Route::rule('manage/getVipMoneyLogs','manage.vip/getVipMoneyLogs');
    Route::rule('manage/saveVip','manage.vip/saveVip');
    Route::rule('manage/delVip','manage.vip/delVip');
    Route::rule('manage/getVipDetail','manage.vip/getVipDetail');
    
    Route::rule('manage/getManageOrderList','manage.order/getOrderList');
    Route::rule('manage/refundManageOrderNo','manage.order/refundOrderNo');
    Route::rule('manage/refundManageOrderYes','manage.order/refundOrderYes');
    Route::rule('manage/writeOffManageOrder','manage.order/writeOffOrder');
    Route::rule('manage/getManageOrderDetail','manage.order/getOrderDetail');
    
    Route::rule('manage/getManageHomeData','manage.index/homeData');
    
    Route::rule('manage/getMoneyList','manage.money/getMoneyLogsList');
    Route::rule('manage/getCashList','manage.money/getCashList');
    Route::rule('manage/addCash','manage.money/addCash');
    Route::rule('manage/saveBank','manage.money/saveBank');
    Route::rule('manage/getBank','manage.money/getBank');
    
    
})->middleware([\app\api\middleware\MemberCheck::class, \app\api\middleware\ManageCheck::class]);