<?php
namespace app\api\middleware;
use app\common\helper\token\TokenHelper;
use app\common\model\member\MemberModel;
class MemberCheck {
    use \app\BaseTrait;
     public function handle($request, \Closure $next)
    {   
        $auth_token = $request->param('token'); 
        if(empty($auth_token)){
            return $this->error('登录状态已经失效,请重新登录',100);
        }
        $res = TokenHelper::getId($auth_token,'miniapp');
        if(false == $res){
            return $this->error('登录状态已经失效,请重新登录',100);
        }
        if($res === 0){
            return $this->error('登录状态已经失效,请重新登录',100);
        } 
        $request->memberId = $res;
        if(null === $member = MemberModel::find($res)){
            return $this->error('登录状态已经失效,请重新登录',100);
        }
        if($member->is_delete == 1){
            return $this->error('登录状态已经失效,请重新登录',100);
        }
        $request->member = $member;
        return $next($request);
     }
    
}