<?php
namespace app\api\controller\manage;
use app\BaseController;
use app\common\model\angling\vip\VipModel;
use app\common\model\angling\vip\VipMoneyLogModel;
use app\common\model\angling\vip\VipProjectModel;
use app\common\model\angling\vip\VipProjectLogModel;
class Vip extends BaseController{
    
    
    public function getVipList(){
        $where = [];
        $page = $this->request->param('page/d',1);
        $limit = $this->request->param('limit/d',10);
        $keyword = $this->request->param('keyword');
        if(!empty($keyword)){
            $where[] = ['mobile|weixin|name','LIKE','%'.$keyword.'%'];
        }
        $where[] = ['angling_id','=', $this->request->anglingId];
        $count = VipModel::where($where)->count();
        $datas = VipModel::withSum('project','num')->where($where)->order(['vip_id'=>'desc'])
                    ->limit($limit)->page($page)
                    ->select()
                    ->toArray();
        return $this->success([
            'datas' => $datas,
            'total' => $count
        ]);
    }
    
    public function getVipDetail(){
        $vipId = $this->request->param('vipId/d');
        if(empty($vipId)){
            return $this->error('请选择要操作的会员');
        }
        if(null === $vip = VipModel::find($vipId)){
            return $this->error('请选择要操作的会员');
        }
        if($vip->angling_id != $this->request->anglingId){
            return $this->error('请选择要操作的会员');
        }
        
        return $this->success([
            'detail' => $vip->toArray()
        ]);
    }
    
    public function addVipMoney(){
        $vipId = $this->request->param('vipId/d');
        if(empty($vipId)){
            return $this->error('请选择要操作的会员');
        }
        if(null === $vip = VipModel::find($vipId)){
            return $this->error('请选择要操作的会员');
        }
        if($vip->angling_id != $this->request->anglingId){
            return $this->error('请选择要操作的会员');
        }
        $money = round($this->request->param('money/f'),2);
        $vip->money = round(($vip->money*100 + $money*100)/100,2);
        $vip->save();
        $vipLogs = new VipMoneyLogModel();
        $vipLogs->save([
            'type' => 1,
            'money' => $money,
            'vip_id' => $vipId,
            'angling_id' => $this->request->anglingId,
        ]);
        return $this->success();
    }
    
    public function useVipMoney(){
        $vipId = $this->request->param('vipId/d');
        if(empty($vipId)){
            return $this->error('请选择要操作的会员');
        }
        if(null === $vip = VipModel::find($vipId)){
            return $this->error('请选择要操作的会员');
        }
        if($vip->angling_id != $this->request->anglingId){
            return $this->error('请选择要操作的会员');
        }
        $money = round($this->request->param('money/f'),2);
        if($vip->money < $money){
            return $this->error('会员余额不足');
        }
        $vip->money = round(($vip->money*100 - $money*100)/100,2);
        $vip->save();
        $vipLogs = new VipMoneyLogModel();
        $vipLogs->save([
            'type' => 2,
            'money' => $money,
            'vip_id' => $vipId,
            'angling_id' => $this->request->anglingId,
        ]);
        return $this->success();
    }
    
    public function getVipProjects(){
        $vipId = $this->request->param('vipId/d');
        $today = date('Y-m-d', time());
        $where = [
             ['angling_id','=', $this->request->anglingId],
             ['vip_id','=',$vipId],
             ['num','>',0],
             ['expire_date','>=',$today]
        ];
        $datas = VipProjectModel::where($where)->order(['project_id'=>'desc'])
                    ->select()
                    ->toArray();
        return $this->success([
            'datas' => $datas
        ]);
        
    }
    
    public function useVipProject(){
        $projectId = $this->request->param('projectId/d');
        if(empty($projectId)){
            return $this->error('请选择要核销的次卡项目');
        }
        if(null === $project = VipProjectModel::find($projectId)){
            return $this->error('请选择要核销的次卡项目');
        }
        if($project->angling_id != $this->request->anglingId){
            return $this->error('请选择要核销的次卡项目');
        }
        $num = $this->request->param('num/d');
        if($project->num < $num){
            return $this->error('次卡剩余数量不够');
        }
        $project->num = $project->num - $num;
        $project->save();
        
        $vipProjectLogs = new VipProjectLogModel();
        $vipProjectLogs->save([
            'project_id' => $projectId,
            'type'  => 2,
            'num'   => $num,
            'vip_id' => $project->vip_id,
            'angling_id' => $this->request->anglingId,
        ]);
        return $this->success();
    }
    
    public  function addVipProject(){
        $vipId = $this->request->param('vipId/d');
        if(empty($vipId)){
            return $this->error('请选择要操作的会员');
        }
        if(null === $vip = VipModel::find($vipId)){
            return $this->error('请选择要操作的会员');
        }
        if($vip->angling_id != $this->request->anglingId){
            return $this->error('请选择要操作的会员');
        }
        $datas = [
            'name' => $this->request->param('name'),
            'num'  => $this->request->param('num/d'),
            'vip_id' => $vipId,
            'angling_id' => $this->request->anglingId,
            'expire_date' => $this->request->param('expire_date'),
        ];
        if(empty($datas['name'])){
            return $this->error('请填写要开通的次卡项目名称');
        }
        if(empty($datas['num'])){
            return $this->error('请选择要开通的次数');
        }
        if(empty($datas['expire_date'])){
            return $this->error('请选择过期时间');
        }
        $vipProject = new VipProjectModel();
        $vipProject->save($datas);
        $vipProjectLogs = new VipProjectLogModel();
        $vipProjectLogs->save([
            'project_id' => $vipProject->project_id,
            'type'  => 1,
            'num'   => $datas['num'],
            'vip_id' => $vipId,
            'angling_id' => $this->request->anglingId,
        ]);
        return $this->success();
    }
    
    
    
    public function getVipProjectLogs(){
        $where = [];
        $page = $this->request->param('page/d',1);
        $limit = $this->request->param('limit/d',10);
        $vipId = $this->request->param('vipId/d');
        $where[] = ['vip_id','=',$vipId];
        $where[] = ['angling_id','=', $this->request->anglingId];
        
        $datas = VipProjectLogModel::with(['project'])->where($where)->order(['log_id'=>'desc'])
                    ->limit($limit)->page($page)
                    ->select()->append(['add_time_format'])
                    ->toArray();
        return $this->success([
            'datas' => $datas
        ]);
    }
    
    public function getVipMoneyLogs(){
        $where = [];
        $page = $this->request->param('page/d',1);
        $limit = $this->request->param('limit/d',10);
        $vipId = $this->request->param('vipId/d');
        $where[] = ['vip_id','=',$vipId];
        $where[] = ['angling_id','=', $this->request->anglingId];
        $datas = VipMoneyLogModel::where($where)->order(['log_id'=>'desc'])
                    ->limit($limit)->page($page)
                    ->select()->append(['add_time_format'])
                    ->toArray();
        return $this->success([
            'datas' => $datas
        ]);
    }
    
    public function saveVip(){
        $vipId = $this->request->param('vipId/d');
        $datas = [
            'angling_id' => $this->request->anglingId,
            'name'   => $this->request->param('name'),
            'mobile' => $this->request->param('mobile'),
            'weixin'  => $this->request->param('weixin'),
        ];
        if(empty($datas['name'])){
            return $this->error('请填写会员的名称');
        }
        if(!is_mobile($datas['mobile'])){
            return $this->error('请填写正确的手机号码');
        }
        if(!empty($vipId)){
            if(null === $vip = VipModel::find($vipId)){
                return $this->error('要编辑的会员不存在');
            }
            if($vip->angling_id != $this->request->anglingId){
                return $this->error('该会员不存在');
            }
        }else{
            $vip = new VipModel();
        }
        $vip->save($datas);
        return $this->success();
    }
    
    public function delVip(){
        $vipId = $this->request->param('vipId/d');
        if(empty($vipId)){
            return $this->error('请选择要删除的会员');
        }
        if(null === $vip = VipModel::find($vipId)){
            return $this->error('请选择要删除的会员');
        }
        if($vip->angling_id != $this->request->anglingId){
            return $this->error('请选择要删除的会员');
        }
        $vip->delete();
        return $this->success();
    }
    
    
    
    
    
    
    
    
}