<?php
namespace app\api\controller\manage;
use app\BaseController;
use app\common\model\angling\TuanModel;
class Tuan extends BaseController{
   
    public function index(){
        
        $datas = TuanModel::where([
            ['angling_id','=', $this->request->anglingId]
        ])->order(['tuan_id'=>'desc'])->select()->toArray();
        
        return $this->success([
            'datas' => $datas
        ]);
    }
    
    public function detail(){
        $tuanId = $this->request->param('tuanId/d');
        if(empty($tuanId)){
            return $this->error('请选择要编辑的抢购活动');
        }
        if(null === $tuan = TuanModel::find($tuanId)){
            return $this->error('请选择要编辑的抢购活动');
        }
        if($tuan->angling_id != $this->request->anglingId){
            return $this->error('请选择要编辑的抢购活动');
        }
        return $this->success([
            'detail' => [
                'tuanId' => $tuanId,
                'title' => $tuan->title,
                'price' => $tuan->price,
                'original_price' => $tuan->original_price,
                'num' => $tuan->num,
                'day' => $tuan->day,
            ],
        ]);
    }
    
    public function del(){
        $tuanId = $this->request->param('tuanId/d');
        if(empty($tuanId)){
            return $this->error('请选择要删除的抢购活动');
        }
        if(null === $tuan = TuanModel::find($tuanId)){
            return $this->error('请选择要删除的抢购活动');
        }
        if($tuan->angling_id != $this->request->anglingId){
            return $this->error('请选择要删除的抢购活动');
        }
        $tuan->delete();
        return $this->success();
    }
    
    public function save(){
        $tuanId = $this->request->param('tuanId/d');
        $datas = [
            'angling_id' => $this->request->anglingId,
            'title'      => $this->request->param('title'),   
            'price'      => round($this->request->param('price/f'),2),
            'original_price'      => round($this->request->param('original_price/f'),2),
            'num'       => $this->request->param('num/d'),
            'day'       => $this->request->param('day'),
        ];
        if(empty($datas['title'])){
            return $this->error('请填写团购标题');
        }
        if(empty($datas['day'])){
            return $this->error('请填写使用日期限制');
        }
        if($datas['price'] <= 0){
            return $this->error('请填写价格');
        }
        if($datas['original_price'] <= 0){
             return $this->error('请填写原价格');
        }
        if(!empty($tuanId)){
            if(null === $tuan = TuanModel::find($tuanId)){
                return $this->error('请选择要编辑的数据');
            }
            if($tuan->angling_id != $this->request->anglingId){
                return $this->error('请选择要编辑的数据');
            }
        }else{
            $tuan = new TuanModel();
        }
        $tuan->save($datas);
        return $this->success();
    }
    
}
