<?php
namespace app\api\controller\manage;
use app\BaseController;
use app\common\model\order\OrderModel;
use app\common\model\angling\MoneyLogModel;
use app\common\helper\miniapp\PaymentHelper;
class  Order extends BaseController{
    
    public function getOrderList(){
        $status = $this->request->param('status/d');
        $where = [
            ['angling_id','=', $this->request->anglingId],
        ];
        $where[] = ['is_paid','=',1];
        switch ($status){
            case 0: //全部
                $where[] = ['status','<>',4];
                break;
            case 1://待使用
                $where[] = ['status','=',0];
                break;
            case 2: //退款中
                $where[] = ['status','=',2];
                break;
            case 3://已使用
                $where[] = ['status','=',8];
                break;
            case 4: //退款单
                $where[] = ['status','=',3];
                break;
            default :
                $where[] = ['status','<>',4];
                break;
        }
        $page = $this->request->param('page/d');
        $limit = $this->request->param('limit/d');
        $datas = OrderModel::with([
            'member' => function($query){
                $query->field('member_id,nickname,face,mobile');
            }
        ])->where($where)->field('order_id,title,photo,price,total_price,num,use_num,status,is_paid,need_pay,member_id')->order(['order_id'=>'desc'])->page($page)->limit($limit)->select()->toArray();
        return $this->success([
            'datas' => $datas
        ]);        
    }
    
    //拒绝退款
    public function refundOrderNo(){
         $orderId = $this->request->param('orderId/d');
        if(empty($orderId)){
           return $this->error('请选择要查看的订单'); 
        }
        if(null === $order = OrderModel::find($orderId)){
            return $this->error('请选择要查看的订单');
        }
        if($order->angling_id != $this->request->anglingId){
            return $this->error('请选择要查看的订单');
        }
        if($order->status !=2 || $order->is_paid != 1){
            return $this->error('该订单状态不能退款');
        }
        $order->status = 0;
        $order->save();
        return $this->success();
    }
    
    //同意退款
    public function refundOrderYes(){
        $orderId = $this->request->param('orderId/d');
        if(empty($orderId)){
           return $this->error('请选择要查看的订单'); 
        }
        if(null === $order = OrderModel::find($orderId)){
            return $this->error('请选择要查看的订单');
        }
        if($order->angling_id != $this->request->anglingId){
            return $this->error('请选择要查看的订单');
        }
        if($order->status !=2 || $order->is_paid != 1){
            return $this->error('该订单状态不能退款');
        }
        $money = round($this->request->param('money/f'),2);
        if($money < 0){ 
            return $this->error('请选择要退款的金额');
        }
        $order->status = 3;
        $order->save();
        $money2 = round(($order->need_pay * 100 - $money * 100)/100,2);
        if($money2 > 0){
            $MoneyLogModel = new MoneyLogModel();
            $MoneyLogModel->save([
                'angling_id' => $order->angling_id,
                'money' => $money2,
                'order_id' => $orderId,
                'status' => 0
            ]);
        }
        if($money > 0){
            $PaymentHelper = new PaymentHelper();
            $PaymentHelper->refund($order->pay_info,$money);
        }
        return $this->success();
    }
    
    public function writeOffOrder(){
        $orderId = $this->request->param('orderId/d');
        if(empty($orderId)){
           return $this->error('请选择要查看的订单'); 
        }
        if(null === $order = OrderModel::find($orderId)){
            return $this->error('请选择要查看的订单');
        }
        if($order->angling_id != $this->request->anglingId){
            return $this->error('请选择要查看的订单');
        }
        if($order->status !=0 || $order->is_paid != 1){
            return $this->error('该订单状态不能核销');
        }
        $orderNum = $order->num - $order->use_num;
        $num = $this->request->param('num/d');
        if($num <=0){
            return $this->error('请输入核销的数量');
        }
        if($num > $orderNum){
            return $this->error('该订单剩余数量不足');
        }
        $order->use_num = $order->use_num + $num;
        if($order->use_num == $order->num){
            $order->status = 8;
        }
        $order->save();
        $money = round(($order->price * 100 * $num)/100,2);
        $MoneyLogModel = new MoneyLogModel();
        $MoneyLogModel->save([
            'angling_id' => $order->angling_id,
            'money' => $money,
            'order_id' => $orderId,
            'status' => 0
        ]);
        return $this->success();
    }
    
    
    public function getOrderDetail(){
        $orderId = $this->request->param('orderId/d');
        if(empty($orderId)){
           return $this->error('请选择要查看的订单'); 
        }
        if(null === $order = OrderModel::find($orderId)){
            return $this->error('请选择要查看的订单');
        }
        if($order->angling_id != $this->request->anglingId){
            return $this->error('请选择要查看的订单');
        }
        $member = $order->member;
        return $this->success([
            'detail' => [
                'order_id' => $orderId,
                'type'     => $order->type,
                'coupon_id' => $order->coupon_id,
                'title'     => $order->title,
                'photo'     => $order->photo,
                'price'     => $order->price,
                'total_price'   => $order->total_price,
                'need_pay'   => $order->need_pay,
                'num'           => $order->num,
                'use_num'       => $order->use_num,
                'status'    => $order->status,
                'is_paid'     => $order->is_paid,
                'coupon'        => $order->coupon,
                'add_time_format' => $order->add_time_format,
                'pay_time_format' => $order->pay_time_format,
                'refund_time_format' => $order->refund_time_format,
                'refund_money'   => $order->refund_money,
                'ext_info'  => $order->ext_info ?? [],
            ],
            'member' => [
                'face' => $member ? $member->face : '',
                'nickname' => $member?$member->nickname:'',
                'mobile'   => $member ? $member->mobile:'',
            ]
         ]);    
    }
    
}