<?php
namespace app\api\controller\manage;
use app\BaseController;
use app\common\model\angling\MoneyLogModel;
use app\common\model\angling\BankModel;
use app\common\model\angling\FreeModel;
use app\common\model\angling\CashModel;
class  Money extends BaseController{
    
    public function getCashList(){
        $page = $this->request->param('page/d');
        $limit = $this->request->param('limit/d');
     
        $datas = CashModel::where([
            ['angling_id','=', $this->request->anglingId]
        ])->order(['log_id'=>'desc'])->page($page)->limit($limit)->select()->append(['add_time_format'])->toArray();
        return $this->success([
            'datas' => $datas
        ]);
        
    }
    
    //一键申请结算
    public function addCash(){
        $time = date('Y-m-d H:i:s',time());
        $free = FreeModel::where([
            ['angling_id','=', $this->request->anglingId],
            ['bg_time','<=',$time],
            ['end_time','>=',$time]
        ])->order(['level'=>'desc','free_id'=>'desc'])->find();
        if(null === $free){
            return $this->error('请联系平台暂未签约费率');
        }
        if(null === $bank = BankModel::find($this->request->anglingId)){
            return $this->error('暂未设置提现账号');
        }
        $total = MoneyLogModel::where([
            ['angling_id','=', $this->request->anglingId],
            ['status','=',0]
        ])->sum('money');
        if($total < 100){
            return $this->error('最小提现金额100元');
        }
        //更新提现记录
        MoneyLogModel::where([
            ['angling_id','=', $this->request->anglingId],
            ['status','=',0]
        ])->save([
            'status' => 1,
        ]);
        $free_money = round((($free->free * 100) * ($total * 100))/1000000,2);
        $money = round(($total*100 - $free_money*100)/100,2);
        $CashModel = new CashModel();
        $CashModel->save([
            'angling_id' => $this->request->anglingId,
            'status' => 0,
            'bank_name' => $bank->bank_name,
            'bank_number' => $bank->bank_number,
            'bank_account' => $bank->bank_account,
            'free'   => $free->free,
            'total_money' => $total,
            'free_money' => $free_money,
            'money'      => $money,
        ]);
        return $this->success();
    }
    
    public function getMoneyLogsList(){
        $page = $this->request->param('page/d');
        $limit = $this->request->param('limit/d');
        $total = MoneyLogModel::where([
            ['angling_id','=', $this->request->anglingId],
            ['status','=',0]
        ])->sum('money');
        $datas = MoneyLogModel::where([
            ['angling_id','=', $this->request->anglingId]
        ])->order(['log_id'=>'desc'])->page($page)->limit($limit)->select()->append(['add_time_format'])->toArray();
        return $this->success([
            'total' => $total,
            'datas' => $datas
        ]);
    }
    
    public function saveBank(){
        if($this->request->manage->role != 1){
            return $this->error('您没有权限修改银行账号');
        }
        $datas = [
            'bank_name' => $this->request->param('bank_name'),
            'bank_number' => $this->request->param('bank_number'),
            'bank_account' => $this->request->param('bank_account')
        ];
        if(empty($datas['bank_name'])){
            return $this->error('银行名称不能为空');
        }
        if(empty($datas['bank_number'])){
            return $this->error('银行账号不能为空');
        }
        if(empty($datas['bank_account'])){
            return $this->error('开户名不能为空');
        }
        if(null === $bank = BankModel::find($this->request->anglingId)){
            $bank = new BankModel();
        }
        $bank->angling_id = $this->request->anglingId;
        $bank->bank_name = $datas['bank_name'];
        $bank->bank_number = $datas['bank_number'];
        $bank->bank_account = $datas['bank_account'];
        $bank->save();
        return $this->success();
    }
    public function getBank(){
        if(null === $bank = BankModel::find($this->request->anglingId)){
            return $this->success([
                'detail' => null,
            ]);
        }
        return $this->success([
            'detail' => [
                'bank_name' => $bank->bank_name,
                'bank_number' => $bank->bank_number,
                'bank_account' => $bank->bank_account,
            ]
        ]);
    }
    
}