<?php
namespace app\api\controller\manage;
use app\BaseController;
use app\common\model\angling\AnglingModel;
use app\common\model\angling\ManageModel;
use app\common\model\angling\MoneyLogModel;
use app\common\model\angling\vip\VipModel;
class Index extends BaseController{
    
    public function homeData(){
        $money =MoneyLogModel::where([
            ['angling_id','=', $this->request->anglingId],
            ['status','=',0]
        ])->sum('money') ?? 0;
        $vip = VipModel::where([
            ['angling_id','=', $this->request->anglingId],
        ])->count() ?? 0; 
        return $this->success([
           'datas' => [
                'money' => round($money,2),
                'anglingId' => $this->request->anglingId,
                'anglingName' => $this->request->angling->name,
                'vipNum' => $vip,
                'rankNum' => $this->request->angling->rank_num,
                 'role' => $this->request->manage->role,
           ]
        ]);
    }
    
    public function index(){
         $datas = ManageModel::with(['angling'=>function($query){
             $query->field('angling_id,name,is_audit');
         }])->where([
             ['member_id','=', $this->request->memberId]
         ])->select()->toArray();
         
         return $this->success(['datas'=>$datas]);
    }
    
       //需要登陆
    public function apply(){
         $datas = [
            'name'    => $this->request->param('name'),
            'photos'      => $this->request->param('photos/a'),
            'detail'        => $this->request->param('detail'),  
            'lat'         => $this->request->param('lat'),
            'lng'         => $this->request->param('lng'),
            'mobile'       => $this->request->param('mobile'),
            'weixin'       => $this->request->param('weixin'), 
            'city_id'     => $this->request->param('city_id/d'),
            'is_tai'     => $this->request->param('is_tai/d'),
            'is_lure'      => $this->request->param('is_lure/d'),  
            'is_audit'      => 0,  
            'fish_type'   => $this->request->param('fish_type/a'),
            'addr'         => $this->request->param('addr'), 
        ];
         if(empty($datas['name'])){
            return $this->error('请填写钓场名称');
        }
        if(empty($datas['photos'])){
            return $this->error('请上传图片');
        }
        if(empty($datas['detail'])){
            return $this->error('请填写钓场说明');
        }
        if(empty($datas['lat']) || empty($datas['lng'])){
            return $this->error('请选择钓场的经纬度坐标');
        }
        if(!is_mobile($datas['mobile'])){
            return $this->error('联系方式不能为空');
        }
        if(empty($datas['weixin'])){
            return $this->error('微信号码不能为空');
        }
        $angling = new AnglingModel();
        $angling->save($datas);
        $manage = new ManageModel();
        $manage->save([
            'member_id' => $this->request->memberId,
            'angling_id' => $angling->angling_id,
            'role'  => 1,
        ]);
        return $this->success();
    }
    
    
    
    
}