<?php
namespace app\api\controller\manage;
use app\BaseController;
use app\common\model\market\HuodongModel;
class Huodong extends BaseController{
    
     public function index(){
        
        $datas = HuodongModel::where([
            ['angling_id','=', $this->request->anglingId]
        ])->order(['huodong_id'=>'desc'])->select()->toArray();
        
        return $this->success([
            'datas' => $datas
        ]);
    }
    
    public function del(){
        $huodongId = $this->request->param('huodongId/d');
        if(empty($huodongId)){
            return $this->error('请选择要删除的数据');
        }
        if(null === $huodong = HuodongModel::find($huodongId)){
            return $this->error('请选择要删除的数据');
        }
        if($huodong->angling_id != $this->request->anglingId){
            return $this->error('请选择要删除的数据');
        }
        $huodong->delete();
        return $this->success('操作成功');
    }
    public function changeStatus(){
        $huodongId = $this->request->param('huodongId/d');
        if(empty($huodongId)){
            return $this->error('请选择要编辑的数据');
        }
        if(null === $huodong = HuodongModel::find($huodongId)){
            return $this->error('请选择要编辑的数据');
        }
        if($huodong->angling_id != $this->request->anglingId){
            return $this->error('请选择要编辑的数据');
        }
        $huodong->status = $huodong->status == 1 ? 0 : 1;
        $huodong->save();
        return $this->success();
    }
    public function save(){
        $huodongId = $this->request->param('huodongId/d');
        $datas = [
            'angling_id'    => $this->request->anglingId,
            'title'      => $this->request->param('title'),   
            'photo'      => $this->request->param('photo'),
            'price'      => round($this->request->param('price/f'),2),
            'original_price'      => round($this->request->param('original_price/f'),2),
            'city_id'       => $this->request->angling->city_id,
            'num'       => $this->request->param('num/d'),
            'fishing_day'       => $this->request->param('fishing_day'),
            'detail'        => $this->request->param('detail'),
            'day' => $this->request->param('day/d'),
            'hour' => $this->request->param('hour/d'),
            'day_refund' => round($this->request->param('day_refund/f'),2),
            'hour_refund' => round($this->request->param('hour_refund/f'),2),
        ];
        if(empty($datas['angling_id'])){
            return $this->error('请选择黑坑商家');
        }
        if(empty($datas['title'])){
            return $this->error('请填写团购标题');
        }
        if(empty($datas['photo'])){
            return $this->error('请上传活动图片');
        }
        if(empty($datas['fishing_day'])){
            return $this->error('请选择垂钓日期');
        }
        if(!empty($huodongId)){
            if(null === $huodong = HuodongModel::find($huodongId)){
                return $this->error('请选择要编辑的数据');
            }
            if($huodong->angling_id != $this->request->anglingId){
                return $this->error('请选择要删除的数据');
            }
        }else{
            $huodong = new HuodongModel();
        }
        $huodong->save($datas);
        return $this->success();
    }
    
    public  function detail(){
        $huodongId = $this->request->param('huodongId/d');
        if(empty($huodongId)){
            return $this->error('请选择要编辑的数据');
        }
        if(null === $huodong = HuodongModel::find($huodongId)){
            return $this->error('请选择要编辑的数据');
        }
        if($huodong->angling_id != $this->request->anglingId){
            return $this->error('请选择要编辑的数据');
        }
        return $this->success([
            'detail' => [
                'huodongId' => $huodong->huodong_id,
                'title'     => $huodong->title,
                'photo'     => $huodong->photo,
                'original_price' => $huodong->original_price,
                'price'     => $huodong->price,
                'num'       => $huodong->num,
                'fishing_day' => $huodong->fishing_day,
                'detail'  => $huodong->detail,
                'day'      => $huodong->day,
                'hour'     => $huodong->hour,
                'day_refund' => $huodong->day_refund,
                'hour_refund'  => $huodong->hour_refund,
            ]
        ]);
    }
    
    
    
}