<?php
namespace app\api\controller\manage;
use app\BaseController;
use app\common\model\market\ExploreModel;
class Explore extends BaseController{
    
    
    public function index(){
        $datas = ExploreModel::where([
            ['angling_id','=', $this->request->anglingId]
        ])->order(['explore_id'=>'desc'])->select()->toArray();
        
        return $this->success([
            'datas' => $datas
        ]);
    }
    public function del(){
        $exploreId = $this->request->param('exploreId/d');
        if(empty($exploreId)){
            return $this->error('请选择要删除的数据');
        }
        if(null === $explore = ExploreModel::find($exploreId)){
            return $this->error('请选择要删除的数据');
        }
        if($explore->angling_id !== $this->request->anglingId){
            return $this->error('请选择要删除的数据');
        }
        $explore->delete();
        return $this->success('操作成功');
    }
   
    public function changeStatus() {
        $exploreId = $this->request->param('exploreId/d');
        if(empty($exploreId)){
            return $this->error('请选择要操作的数据');
        }
        if(null === $explore = ExploreModel::find($exploreId)){
            return $this->error('请选择要操作的数据');
        }
        if($explore->angling_id !== $this->request->anglingId){
            return $this->error('请选择要操作的数据');
        }
        $explore->status = $explore->status == 1 ? 0 : 1;
        $explore->save();
        return $this->success();
    }
    public function detail(){
        $exploreId = $this->request->param('exploreId/d');
        if(empty($exploreId)){
            return $this->error('请选择要编辑的数据');
        }
        if(null === $explore = ExploreModel::find($exploreId)){
            return $this->error('请选择要编辑的数据');
        }
        if($explore->angling_id !== $this->request->anglingId){
            return $this->error('请选择要编辑的数据');
        }
        return $this->success([
            'detail' => [
                'exploreId' => $explore->explore_id,
                'title'     => $explore->title,
                'photo'     => $explore->photo,
                'original_price' => $explore->original_price,
                'price'     => $explore->price,
                'num'       => $explore->num,
                'detail'  => $explore->detail,
            ]
        ]);
    }
    public function save(){
        $exploreId = $this->request->param('exploreId/d');
        $datas = [
            'angling_id'    => $this->request->anglingId,
            'title'      => $this->request->param('title'),   
            'photo'      => $this->request->param('photo'),
            'price'      => round($this->request->param('price/f'),2),
            'original_price'      => round($this->request->param('original_price/f'),2),
            'city_id'       => $this->request->angling->city_id,
            'num'       => $this->request->param('num/d'),
            'detail'        => $this->request->param('detail')
         
        ];
       
        if(empty($datas['title'])){
            return $this->error('请填写标题');
        }
        if(empty($datas['photo'])){
            return $this->error('请上传活动图片');
        }
        if(!empty($exploreId)){
            if(null === $explore = ExploreModel::find($exploreId)){
                return $this->error('请选择要编辑的数据');
            }
            if($explore->angling_id !== $this->request->anglingId){
                return $this->error('请选择要编辑的数据');
            }
        }else{
            $explore = new ExploreModel();
        }
        $explore->save($datas);
        return $this->success();
    }
   
    
}
