<?php
namespace app\api\controller;
use app\common\helper\oss\OssHelper;
use app\common\model\data\ImageModel;
use app\BaseController;
use think\Exception;
class Upload extends BaseController{
    
    public function upload() {
        try {
            if (empty($_FILES['file'])) {
                throw new Exception('请上传图片');
            }

            $OssHelper = new OssHelper();
            $res = $OssHelper->upload($_FILES['file']);
            //写入数据库
            $ImageModel = new ImageModel();
            $ImageModel->save([
                'album_id' => 0,
                'from_type' => 'miniapp',
                'member_id' => $this->request->memberId,
                'hash' => $res['hash'],
                'key' => $res['key'],
                'url' => $res['url'],
                'size' => $res['size'],
                'ext' => $res['ext'],
            ]);
            return $this->success([
                'img'=>$res['url'],
            ]);
        } catch (Exception $e) {
            return $this->error($e->getMessage());
        }
    }
    
}
