<?php
namespace app\api\controller;
use app\BaseController;
use app\common\model\rapac\RapacModel;
class Rapac extends BaseController{
    
    public function index(){
        $cityId = $this->request->param('cityId/d');
        if(empty($cityId)){
            return $this->success();
        }
        $where = [
            ['city_id','=',$cityId],
            ['is_audit','=',1]
        ];
        $return['datas'] = RapacModel::where($where)
                           ->order(['rapac_id'=>'desc']) 
                           ->select()->append(['add_time_format'])
                           ->toArray();
        return $this->success($return);
    }
    
    public  function add(){
         $datas = [
            'name'    => $this->request->param('name'),
            'photos'      => $this->request->param('photos/a'),
            'desc'        => $this->request->param('desc'),  
            'lat'         => $this->request->param('lat'),
            'lng'         => $this->request->param('lng'),
            'member_id'   => $this->request->memberId,  
            'city_id'     => $this->request->param('city_id/d'),
            'is_cat'     => $this->request->param('is_cat/d'),
            'is_lure'      => $this->request->param('is_lure/d'),  
            'is_audit'      => 0,  
            'fish_type'   => $this->request->param('fish_type/a'),
        ];
        if(empty($datas['name'])){
            return $this->error('请填写钓点名称');
        }
        if(empty($datas['photos'])){
            return $this->error('请上传图片');
        }
        if(empty($datas['desc'])){
            return $this->error('请填写钓点说明');
        }
        if(empty($datas['lat']) || empty($datas['lng'])){
            return $this->error('请选择钓点的经纬度坐标');
        }
        $rapac = new RapacModel();
        $rapac->save($datas);
        IntegralLogic::getInstance()->addIntegralByType('rapac', $this->request->memberId);

        return $this->success('提交成功');
    }
    
    public function detail(){
        $rapacId = $this->request->param('rapacId/d');
        if(empty($rapacId)){
            return $this->error('请选择要查看的野钓地点');
        }
        if(null === $rapac  = RapacModel::find($rapacId)){
            return $this->error('请选择要查看的野钓地点');
        }
        $rapac->member;
        return $this->success([
            'detail' => [
                'member' =>[
                    'nickname' => $rapac->member ? $rapac->member->nickname:'匿名用户',
                    'face'     => $rapac->member ? $rapac->member->face:'',
                ],
                'rapac_id' => $rapac->rapac_id,
                'name'   => $rapac->name,
                'photos' => $rapac->photos,
                'fish_type' => empty($rapac->fish_type) ? '' : join('、',$rapac->fish_type ),
                'desc'   => $rapac->desc,
                'lat'    => $rapac->lat,
                'lng'    => $rapac->lng,
                'is_cat'  => $rapac->is_cat,
                'is_lure'  => $rapac->is_lure
            ],
        ]);
    }
    
    
}