<?php
namespace app\api\controller;
use app\BaseController;
use app\common\model\order\OrderModel;
use app\common\model\market\HuodongModel;
use app\common\model\angling\TuanModel;
use app\common\model\market\ExploreModel;
use app\common\logic\order\CreateOrderLogic;
use app\common\model\member\MemberCouponModel;
use app\common\helper\miniapp\PaymentHelper;
use think\Exception;
class Order extends BaseController{
    
    
    public function getOrderPay(){
        $orderId = $this->request->param('orderId/d');
        if(empty($orderId)){
           return $this->error('请选择要支付的订单'); 
        }
        if(null === $order = OrderModel::find($orderId)){
            return $this->error('请选择要支付的订单');
        }
        if($order->member_id != $this->request->memberId){
            return $this->error('请选择要支付的订单');
        }
        if($order->status != 0 || $order->is_paid == 1){
            return $this->error('该订单暂时不能继续支付');
        }
        if($order->need_pay == 0){
            $order->is_paid = 1;
            $order->pay_time = time();
            $order->save();
            if(!empty($order->coupon_id)){
                MemberCouponModel::where('id',$order->coupon_id)->save([
                    'status' => 1
                ]);
            }
            if($order->type == 1){
                TuanModel::where('tuan_id',$order->data_id)->setDec('num',$order->num);
            }
            else if($order->type == 2){
                HuodongModel::where('huodong_id',$order->data_id)->setDec('num',$order->num);
                HuodongModel::where('huodong_id',$order->data_id)->setInc('sold_num',$order->num);
            }else if($order->type == 3){
                ExploreModel::where('explore_id',$order->data_id)->setDec('num',$order->num);
            }
            return $this->success([
                'is_paid'  => 1,
            ]);
        }
        $PaymentHelper  =  new PaymentHelper();
        $res = $PaymentHelper->getPayment([
            'product_name' => $order->title,
            'order_id'     => $orderId,
            'need_pay'     => $order->need_pay,
            'open_id'      => $this->request->member->open_id, 
        ]);
        return $this->success([
            'is_paid' => 0,
            'payment' => $res
        ]);
    }
    
    //申请退款
    public function applyRefund(){
        $orderId = $this->request->param('orderId/d');
        if(empty($orderId)){
           return $this->error('请选择要支付的订单'); 
        }
        if(null === $order = OrderModel::find($orderId)){
            return $this->error('请选择要支付的订单');
        }
        if($order->member_id != $this->request->memberId){
            return $this->error('请选择要支付的订单');
        }
        if($order->is_paid != 1){
            return $this->error('该订单不可以申请退款');
        }
        if($order->status !=0){
            return $this->error('该订单不可以申请退款');
        }
        if($order->use_num > 0){
            return $this->error('该订单不可以申请退款');
        }
        $order->refund_time = time();
        $order->status = 2; // 申请退款
        $order->save();
        return $this->success();
    }
    
    //未支付的订单取消订单
    public function cancelOrder(){
        $orderId = $this->request->param('orderId/d');
        if(empty($orderId)){
           return $this->error('请选择要支付的订单'); 
        }
        if(null === $order = OrderModel::find($orderId)){
            return $this->error('请选择要支付的订单');
        }
        if($order->member_id != $this->request->memberId){
            return $this->error('请选择要支付的订单');
        }
        if($order->is_paid == 1){
            return $this->error('该订单取消失败');
        }
        if($order->status != 0){
            return $this->error('该订单取消失败');
        }
        $order->status = 4;
        $order->save();
        return $this->success();
    }
    
    public function payRespond(){
        $PaymentHelper  =  new PaymentHelper();
        return $PaymentHelper->respond();
    }
    
    public function getOrderList(){
        $status = $this->request->param('status/d');
        $where = [
            ['member_id','=', $this->request->memberId],
        ];
        switch ($status){
            case 0: //全部
                break;
            case 1://待使用
                $where[] = ['is_paid','=',1];
                $where[] = ['status','=',0];
                break;
            case 2: //退款中
                $where[] = ['is_paid','=',1];
                $where[] = ['status','=',2];
                break;
            case 3://已使用
                $where[] = ['is_paid','=',1];
                $where[] = ['status','=',8];
                break;
            case 4: //已取消
                $where[] = ['status','IN',[3,4]];
                break;
            default :
                break;
        }
        $page = $this->request->param('page/d');
        $limit = $this->request->param('limit/d');
        $datas = OrderModel::with([
            'angling'=>function($query){
                $query->field('angling_id,name,lat,lng');
            }
        ])->where($where)->field('order_id,title,photo,price,total_price,num,use_num,status,is_paid,need_pay,angling_id')->order(['order_id'=>'desc'])->page($page)->limit($limit)->select()->toArray();
        return $this->success([
            'datas' => $datas
        ]);
    }
    
    public function getOrderDetail(){
        $orderId = $this->request->param('orderId/d');
        if(empty($orderId)){
           return $this->error('请选择要查看的订单'); 
        }
        if(null === $order = OrderModel::find($orderId)){
            return $this->error('请选择要查看的订单');
        }
        if($order->member_id != $this->request->memberId){
            return $this->error('请选择要查看的订单');
        }
        $angling = $order->angling;
        
        return $this->success([
            'detail' => [
                'order_id' => $orderId,
                'type'     => $order->type,
                'coupon_id' => $order->coupon_id,
                'title'     => $order->title,
                'photo'     => $order->photo,
                'price'     => $order->price,
                'total_price'   => $order->total_price,
                'need_pay'   => $order->need_pay,
                'num'           => $order->num,
                'use_num'       => $order->use_num,
                'status'    => $order->status,
                'is_paid'     => $order->is_paid,
                'coupon'        => $order->coupon,
                'add_time_format' => $order->add_time_format,
                'pay_time_format' => $order->pay_time_format,
                'refund_time_format' => $order->refund_time_format,
                'refund_money'   => $order->refund_money,
                'ext_info'  => $order->ext_info ?? [],
            ],
            'angling' => [
                'angling_id' => $angling->angling_id,
                'name'       => $angling->name,
                'addr'       => $angling->addr,
                'mobile'     => $angling->mobile,
                'weixin'     => $angling->weixin,
                'lat'        => $angling->lat,
                'lng'        => $angling->lng,
            ],
        ]);
    }
    
    public function createTuanOrder(){
        $tuanId = $this->request->param('tuanId/d');
        if(empty($tuanId)){
            return $this->error('请选择要购买的团购');
        }
        $num = $this->request->param('num/d');
        if($num<=0){
            return $this->error('请选择要购买的数量');
        }
        if(null === $tuan = TuanModel::find($tuanId)){
            return $this->error('请选择要购买的团购');
        }
        if($tuan->num < $num){
            return $this->error('该抢购剩余数量不足');
        }
        $angling = $tuan->angling;
        if(null === $angling){
            return $this->error('关联钓场已经停业');
        }
        $coupon_id = $this->request->param('coupon_id/d');
        $total_price = round(($num * ($tuan->price*100))/100,2);
        try {
           $orderId = CreateOrderLogic::getInstance()->create([
               'city_id'    => $angling->city_id,
               'member_id'  => $this->request->memberId,
               'angling_id' => $tuan->angling_id,
               'coupon_id'  => $coupon_id,
               'num'        => $num,
               'use_num'    => 0,
               'title'      => $tuan->title,
               'price'      => $tuan->price,
               'photo'      => '',
               'type'       => 1,
               'data_id'    => $tuanId,
               'total_price' => $total_price,
               'need_pay'    => $total_price,
               'price'       => $tuan->price,
               'ext_info'    => [],
           ]); 
           return $this->success([
               'orderId' => $orderId,
           ]);
        } catch (Exception $e) {
           return $this->error($e->getMessage()); 
        }
    }    
    public function createExploreOrder(){
        $exploreId = $this->request->param('exploreId/d');
        if(empty($exploreId)){
            return $this->error('请选择要购买的体验价活动');
        }
        if(null === $explore = ExploreModel::find($exploreId)){
            return $this->error('请选择要购买的体验价活动');
        }
        if($explore->status != 1){
            return $this->error('该活动已经下架');
        }
        if($explore->num < 1){
            return $this->error('该活动已经售罄');
        }
        $has = OrderModel::where([
            ['member_id','=', $this->request->memberId],
            ['type','=',3],
            ['data_id','=',$exploreId]
        ])->count() ?? 0;
        if($has > 0 ){
            return $this->error('您已经购买过了');
        }
        $coupon_id = $this->request->param('coupon_id/d');
        try {
           $orderId = CreateOrderLogic::getInstance()->create([
               'city_id'    => $explore->city_id,
               'member_id'  => $this->request->memberId,
               'angling_id' => $explore->angling_id,
               'coupon_id'  => $coupon_id,
               'num'        => 1,
               'use_num'    => 0,
               'title'      => $explore->title,
               'price'      => $explore->price,
               'photo'      => $explore->photo,
               'type'       => 3,
               'data_id'    => $exploreId,
               'total_price' => $explore->price,
               'price'     => $explore->price,
               'need_pay'    => $explore->price,
               'ext_info'   => [],
           ]); 
           return $this->success([
               'orderId' => $orderId,
           ]);
        } catch (Exception $e) {
           return $this->error($e->getMessage()); 
        }
    }
    public function createHuodongOrder(){
        $huodongId = $this->request->param('huodongId/d');
        if(empty($huodongId)){
            return $this->error('请选择要参与的活动');
        }
        $num = $this->request->param('num/d');
        if($num<=0){
            return $this->error('请选择要购买的数量');
        }
        if(null === $huodong = HuodongModel::find($huodongId)){
            return $this->error('该活动不存在');
        }
        if($huodong->status != 1){
            return $this->error('该活动已经下架了');
        }
        if($huodong->num < $num){
            return $this->error('该活动剩余名额不足');
        }
        $today = date('Y-m-d',time());
        if($huodong->fishing_day < $today){
            return $this->error('该活动已经结束了');
        }
        $coupon_id = $this->request->param('coupon_id/d');
        $total_price = round(($num * ($huodong->price*100))/100,2);
        try {
           $orderId = CreateOrderLogic::getInstance()->create([
               'city_id'    => $huodong->city_id,
               'member_id'  => $this->request->memberId,
               'angling_id' => $huodong->angling_id,
               'coupon_id'  => $coupon_id,
               'num'        => $num,
               'use_num'    => 0,
               'title'      => $huodong->title,
               'price'      => $huodong->price,
               'photo'      => $huodong->photo,
               'type'       => 2,
               'data_id'    => $huodongId,
               'total_price' => $total_price,
               'need_pay'    => $total_price,
               'price'       => $huodong->price,
               'ext_info'    => [
                   'fishing_day'=>$huodong->fishing_day,
                   'day' => $huodong->day,
                   'hour' => $huodong->hour,
                   'day_refund' => $huodong->day_refund,
                   'hour_refund' => $huodong->hour_refund,
               ],
           ]); 
           return $this->success([
               'orderId' => $orderId,
           ]);
        } catch (Exception $e) {
           return $this->error($e->getMessage()); 
        }
    }
    
}
