<?php
namespace app\api\controller;
use app\BaseController;
use app\common\model\order\OrderModel;
use app\common\model\member\MemberCouponModel;
use app\common\model\member\IntegralModel;

class Member extends BaseController{
    
    public function getMemberCount(){
        $integral  = $this->request->member->integral;
        $order = OrderModel::where([
            ['is_paid','=',1],
            ['status','=',0],
            ['member_id','=', $this->request->memberId]
        ])->count() ?? 0;
        $today = date('Y-m-d',time());
        $coupon = MemberCouponModel::where([
            ['expire_time','>',$today],
            ['member_id','=', $this->request->memberId],
            ['status','=',0]
        ])->count() ?? 0;
        
        return $this->success([
            'integral' => $integral,
            'order'    => $order,
            'coupon'   => $coupon
        ]);
    }
    
    public function integral(){
        $where = [];
        $page = $this->request->param('page/d',1);
        $limit = $this->request->param('limit/d',10);
        $where[] = ['member_id','=', $this->request->memberId];
        $datas = IntegralModel::where($where)
                            ->field('type,info,num,add_time')
                            ->order(['log_id'=>'desc'])->limit($limit)->page($page)
                           ->select()->append(['add_time_format'])
                           ->toArray();
        return $this->success([
            'datas' => $datas,
            'integral' => $this->request->member->integral,
        ]);
        
    }
}
