<?php
namespace app\api\controller;
use app\BaseController;
use app\common\model\market\LotteryModel;
use app\common\model\market\LotteryJoinModel;
class  Lottery extends BaseController{
    
    public function index(){
        $where = $order = [];
        $page = $this->request->param('page/d',1);
        $limit = $this->request->param('limit/d',10);
        $t = time();
        $time = date('Y-m-d H:i:s', $t);
        $type = $this->request->param('type/d');
        if($type == 0){ //正在进行重
            $order = ['open_time'=>'asc'];
            $where[] = ['status','=',0];
            $where[] = ['bg_time','<=',$time];
            
        }elseif($type == 1){//即将开始
            $order = ['bg_time'=>'asc'];
            $where[] = ['status','=',0];
            $where[] = ['bg_time','>',$time];
        }else{ //往期回归
            $order = ['open_time'=>'desc','lottery_id'=>'desc'];
            $where[] = ['status','=',8];
        }
        $datas = LotteryModel::where($where)
                            ->field('lottery_id,title,exclusive,luck_num,bg_time,open_time,status')
                            ->order($order)->limit($limit)->page($page)
                           ->select()
                           ->toArray();
        foreach($datas as $key=>$val){
            $bg = strtotime($val['bg_time']) -  $t;
            $open = strtotime($val['open_time']) -  $t;
            if($val['status'] == 0){
                if($open <= 0){ //等待开奖
                    $val['real_status'] = 1;
                }elseif($bg <= 0){ //正在进行中
                    $val['real_status'] = 0;
                }else{//即将开始
                    $val['real_status'] = 2;
                }
            }else{
                $val['real_status'] = 8;
            }
            $val['bg'] = $bg;
            $val['open'] = $open;
            $datas[$key] = $val;
        }
        return $this->success([
            'datas' => $datas
        ]);
    }
    
    public function detail(){
        $lotteryId = $this->request->param('lotteryId/d');
        if(empty($lotteryId)){
            return $this->error('您访问的领取鱼饵活动不存在');
        }
        if(null === $lottery = LotteryModel::find($lotteryId)){
            return $this->error('您访问的领取鱼饵活动不存在');
        }
        $myJoin = null;
        if(isset($this->request->memberId)){
            $myJoin = LotteryJoinModel::where([
                ['lottery_id','=',$lotteryId],
                ['member_id','=', $this->request->memberId]
            ])->find();
        }
        $t = time();
        $bg = strtotime($lottery->bg_time) - $t;
        $open = strtotime($lottery->open_time) - $t;
   
        return $this->success([
            'detail' => $lottery->toArray(),
            'myJoin' => $myJoin,
            'bg'     => $bg,
            'open'   => $open,//距离开奖的时间 
        ]);
    }
    
    public function getJoinList(){
        $lotteryId = $this->request->param('lotteryId/d');
        if(empty($lotteryId)){
            return $this->error('您访问的领取鱼饵活动不存在');
        }
        $page = $this->request->param('page/d',1);
        $limit = $this->request->param('limit/d',10);
        $count = LotteryJoinModel::where([
            ['lottery_id','=',$lotteryId]
        ])->count();
        $datas  = LotteryJoinModel::with(['member'=>function($query){
            $query->field('member_id,nickname,face');
        }])->where([
            ['lottery_id','=',$lotteryId]
        ])->order(['rate'=>'desc','id'=>'asc'])->limit($limit)->page($page)->select()->toArray();

        return $this->success([
            'datas' => $datas,
            'count'  => $count
        ]);
    }
    
    
    
    public function joinAct(){
        $lotteryId = $this->request->param('lotteryId/d');
        $pid = $this->request->param('pid/d');
        if(empty($lotteryId)){
            return $this->error('您访问的领取鱼饵活动不存在');
        }
        if(null === $lottery = LotteryModel::find($lotteryId)){
            return $this->error('您访问的领取鱼饵活动不存在');
        }
        if($lottery->status != 0){
            return $this->error('该活动还不能参加');
        }
        $time = time();
        if(strtotime($lottery->bg_time) - $time > 0){
            return $this->error('该活动还不能参加');
        }
        $t = strtotime($lottery->open_time) - $time;
        if($t < 0){
            return $this->error('该活动即将开奖');
        }
        if(null !== $has = LotteryJoinModel::where([
            ['member_id','=', $this->request->memberId],
            ['lottery_id','=',$lotteryId]
        ])->find()){
            return $this->error('您已经参与了该活动');
        }
        $LotteryJoinModel = new LotteryJoinModel();
        $LotteryJoinModel->save([
            'lottery_id' => $lotteryId,
            'member_id'  => $this->request->memberId,
            'rate'       => 1,
            'status'     => 0
        ]);
        if(!empty($pid)){
            LotteryJoinModel::where([
                ['lottery_id','=',$lotteryId],
                ['member_id','=',$pid]
            ])->inc('rate')->save();
        }
        return $this->success();
    }
    
    
    
}
