<?php
namespace app\api\controller;
use app\BaseController;
use app\common\model\member\MemberModel;
use app\common\helper\token\TokenHelper;
use app\common\helper\miniapp\MiniappHelper;
use app\common\logic\member\IntegralLogic;
class Login extends BaseController{
    
    //更新昵称头像
    public function nickInfo(){
        $face = $this->request->param('face');
        $nickname = $this->request->param('name');
        if(empty($face) || empty($nickname)){
           return $this->error('头像和昵称不能为空');
        }
        $member = $this->request->member;
        $member->face = $face;
        $member->nickname = $nickname;
        $member->save();
        return $this->success([
            'member' => [
                'memberId'=> $member->member_id,
                'face'    => $member->face,
                'nickname'    => $member->nickname,
                'mobile'  => $member->mobile      
            ]
        ]);
    }
    
    //可以更改绑定的手机号码
    public function changeMobile(){
        $code   = $this->request->param('code');
        $mobile = MiniappHelper::getInstance()->getMobile($code);
        if(empty($mobile)){
            return $this->error('解析手机号失败');
        }
        $member = $this->request->member;
        $member->mobile = $mobile;
        $member->save();
        return $this->success([
            'member' => [
                'memberId'=> $member->member_id,
                'face'    => $member->face,
                'nickname'    => $member->nickname,
                'mobile'  => $member->mobile            
            ]
        ]);
    }    
    
    //首次登陆需要绑定手机号码
    public function bindMobile(){
        $openId = $this->request->param('openId');
        $code   = $this->request->param('code');
        $pid    = $this->request->param('pid/d');
        $cityId = $this->request->param('cityId/d');
        if(empty($openId) || empty($code)){
            return $this->error('登陆参数有误');
        }
        if(null !== $has = MemberModel::where('open_id',$openId)->find()){
            return $this->error('登陆失败');
        }
        $mobile = MiniappHelper::getInstance()->getMobile($code);
        if(empty($mobile)){
            return $this->error('解析手机号失败');
        }
        $data = [
            'nickname' => '',
            'face'     => '',
            'open_id' => $openId,
            'mobile'   => $mobile,
            'pid'      => $pid,
            'city_id'  => $cityId,
            'is_new'   => 1,
        ];
        $member = new MemberModel();
        $member->save($data);
        IntegralLogic::getInstance()->addIntegralByType('register', $member->member_id);
        if(!empty($pid)){
            IntegralLogic::getInstance()->addIntegralByType('agent', $pid);
        }
        return $this->success([
            'member' => [
                'memberId'=> $member->member_id,
                'face'    => $member->face,
                'nickname'    => $member->nickname,
                'mobile'  => $member->mobile                
            ],
            'token'  => TokenHelper::getToken($member->member_id,'miniapp')
        ]);
    }
    
    public function login(){
        $code = $this->request->param('code');
        if(empty($code)){
            return $this->error('请先登陆');
        }
        $openId = MiniappHelper::getInstance()->getOpenId($code);
        if(empty($openId)){
            return $this->error('获取OpenId失败');
        }
        if(null === $member = MemberModel::where('open_id',$openId)->find()){
            return $this->success([
                'openId' => $openId,
                'member' => null,
                'token'  => null,   
            ]);
        }
        if($member->is_delete == 1){
            return $this->error('该账号已经被禁用');
        }

        return $this->success([
            'openId' => $openId,
            'member' => [
                'memberId'=> $member->member_id,
                'face'    => $member->face,
                'nickname'    => $member->nickname,
                'mobile'  => $member->mobile                
            ],
            'token'  => TokenHelper::getToken($member->member_id,'miniapp')
        ]);
    }
    
}