<?php
namespace app\api\controller;
use app\BaseController;
use app\common\logic\setting\SettingLogic;
use app\common\model\data\CityModel;
use app\common\model\angling\AnglingModel;
use app\common\model\member\ClockModel;
use app\common\model\market\ExploreModel;
use app\common\model\market\HuodongModel;
use app\common\model\team\TeamBuildingModel;
use app\common\model\data\BannerModel;
class Index extends BaseController{
    
    public function init(){
       $site = SettingLogic::getInstance()->getDataByKey('site');
       $style =  SettingLogic::getInstance()->getDataByKey('style');
       $fish = SettingLogic::getInstance()->getDataByKey('fish');
       $mall = SettingLogic::getInstance()->getDataByKey('mall');
       $citys = CityModel::where([
           ['is_open','=',1]
       ])->select()->hidden(['add_time','add_ip'])->toArray();
       
       return $this->success([
           'site' => $site,
           'style' => $style,
           'fish'  => $fish, 
           'city'  => $citys,
           'mall'  => $mall
       ]);
    }
    
    //获取首页数据推送
    public function getHomeDatas(){
        $cityId = $this->request->param('cityId/d');
        $datas = cache('home-data-'.$cityId);
        $day = date('Y-m-d',time());
        if(empty($datas)){
            $datas = [];
            $datas['explore'] = ExploreModel::where([
                ['city_id','=',$cityId],
                ['status','=',1]
            ])->field('explore_id,title,photo,original_price,price,num')
            ->order(['explore_id'=>'desc'])->limit(2)->select()->toArray() ?? [];
            $datas['huodong'] = HuodongModel::where([
                ['city_id','=',$cityId],
                ['status','=',1],
                ['fishing_day','>',$day]
            ]) ->field('huodong_id,title,photo,original_price,price,num,fishing_day') 
                ->order(['fishing_day'=>'asc','huodong_id'=>'desc'])->limit(2)->select()->toArray() ?? [];
            
            $datas['clock'] = ClockModel::with(['member'=>function($query){
                    $query->field('member_id,nickname,face');
                },'angling'=>function($query){
                    $query->field('angling_id,name,photos,fish_type,lng,lat');
                },'rapac'=>function($query){
                    $query->field('rapac_id,name,photos,fish_type,lng,lat');
                }])->where([
                     ['city_id','=',$cityId],
                     ['status','=',1]
                ])->field('clock_id,type,angling_id,rapac_id,member_id,photos,desc')
                                   ->order(['clock_id'=>'desc']) 
                                   ->limit(20)
                                   ->select()
                                   ->toArray();
                
            $datas['angling'] = AnglingModel::where([
                ['city_id','=',$cityId],
                ['is_audit','=',1]
            ])->field('angling_id,name,rank_num,lat,lng')
                    ->order(['rank_num'=>'desc','angling_id'=>'desc'])->limit(3)->select()->toArray();   
            $datas['banner'] = BannerModel::where([
                ['city_id','IN',[0,$cityId]],
            ])->order(['sort'=>'desc','id'=>'desc'])->limit(5)->select()->toArray();
            
            cache('home-data-'.$cityId,$datas,600);
        }
        return $this->success($datas);
    }
    
    
    public  function teamOrder(){
        $datas = [
            'city_id' => $this->request->param('city_id/d'),
            'company'  => $this->request->param('company'),
            'num'       => $this->request->param('num/d'),
            'budget'        => $this->request->param('budget'),
            'is_take'    => $this->request->param('is_take/d'),
            'name'     => $this->request->param('name'),
            'mobile'        => $this->request->param('mobile'),
            'info'  => $this->request->param('info'),
            'day'   => $this->request->param('day'),
            'status'    => 0,
        ];
        if(empty($datas['city_id'])){
            return $this->error('请选择城市');
        }
        if(empty($datas['company'])){
            return $this->error('请填写团队或者公司名称');
        }
        if(empty($datas['num'])){
            return $this->error('请输入大概人数');
        }
        if(empty($datas['fish_type'])){
            return $this->error('请选择目标鱼种');
        }
        if(empty($datas['name'])){
            return $this->error('对接联系人不能为空');
        }
        if(!is_mobile($datas['mobile'])){
            return $this->error('请填写手机号码');
        }
        
        $team = new TeamBuildingModel();
        $team->save($datas);
        return $this->success();
    }
}
