<?php
namespace app\api\controller;
use app\BaseController;
use app\common\model\market\HuodongModel;
class Huodong extends BaseController{
    
    
    public function index(){
        $time = time();
        $dayArr = $dateArr = [];
        for($i = 1; $i<=5;$i++){
            $time+= 86400;
            $dayArr[] =  date('m/d',$time);
            $dateArr[] = date('Y-m-d',$time);
        }
        $day = $this->request->param('day');
        $day = empty($day) ? $dateArr[0] : $day;
        if(!in_array($day, $dateArr)){
            return $this->error('请选择查看正确的日期');
        }
        $cityId = $this->request->param('cityId/d');
        if(empty($cityId)){
            return $this->error('当前定位失败');
        }
        $where = [
            ['fishing_day','=',$day],
            ['city_id','=',$cityId],
            ['status','=',1]
        ];
        $datas = HuodongModel::with(['angling'=>function($query){
            $query->field('angling_id,name,lat,lng,addr');
        }])->where($where)->field('huodong_id,angling_id,title,photo,original_price,price,num,fishing_day')->select()->toArray();

        return $this->success([
            'datas'=>$datas,
            'dayArr' => $dayArr,
            'dateArr' => $dateArr
        ]);
    }
    
    public function detail(){
        $huodongId = $this->request->param('huodongId/d');
        if(empty($huodongId)){
            return $this->error('查看的活动不存在');
        }
        if(null === $huodong = HuodongModel::find($huodongId)){
            return $this->error('查看的活动不存在');
        }
        if($huodong->status != 1){
            return $this->error('该活动还未开放');
        }
        $huodong->angling;
        if(null === $huodong->angling){
            return $this->error('关联钓场已停业');
        }
        return $this->success([
            'detail' => [
                'huodong_id'=> $huodongId,
                'title'  => $huodong->title,
                'photo' => $huodong->photo,
                'original_price' => $huodong->original_price,
                'price' => $huodong->price,
                'num'    => $huodong->num,
                'fishing_day' => $huodong->fishing_day,
                'detail'    => $huodong->detail,
                'day'       => $huodong->day,
                'hour'      => $huodong->hour,
                'day_refund' => $huodong->day_refund,
                'hour_refund' => $huodong->hour_refund,
            ],
            'angling' => [
                'angling_id' =>$huodong->angling->angling_id,
                'name'       => $huodong->angling->name,
                'photos'     => $huodong->angling->photos,
                'addr'       => $huodong->angling->addr,
                'lat'       => $huodong->angling->lat,
                'lng'       => $huodong->angling->lng,
                'mobile'    => $huodong->angling->mobile,
            ]
        ]);
    }
    
    
    
}

