<?php

namespace app\api\controller;

use app\BaseController;
use app\common\model\market\ExploreModel;
use app\common\model\order\OrderModel;
class Explore extends BaseController {

    public function index() {
        $return = $where = [];
        $page = $this->request->param('page/d', 1);
        $limit = $this->request->param('limit/d', 10);
        $cityId = $this->request->param('cityId/d');
        if (empty($cityId)) {
            return $this->error('城市定位失败');
        }
        $where[] = ['city_id', '=', $cityId];
        $where[] = ['status', '=', 1];
        $return['datas'] = ExploreModel::with(['angling' => function ($query) {
                        $query->field('angling_id,name,lat,lng,addr');
                    }])->where($where)->field('explore_id,angling_id,title,photo,original_price,price,num')
                ->order(['explore_id' => 'desc'])
                ->limit($limit)->page($page)
                ->select()
                ->toArray();  
        $return['hasIds'] = [];
        if(isset($this->request->memberId)){
            $ids = [];
            foreach($return['datas'] as $val){
                $ids[] = $val['explore_id'];
            }
            if(!empty($ids)){
                $hasIds = OrderModel::where([
                    ['member_id','=', $this->request->memberId],
                    ['type','=',3],
                    ['data_id','IN',$ids],
                    ['is_paid','=',1]
                ])->column('data_id');
                $return['hasIds'] = $hasIds;
            }
        }            
                    
        return $this->success($return);
    }
    
   

    public function detail() {
        //当检测到登录后需要增加是否买过的计算            
        $exploreId = $this->request->param('exploreId/d');
        if (empty($exploreId)) {
            return $this->error('查看的内容不存在');
        }
        if (null === $explore = ExploreModel::find($exploreId)) {
            return $this->error('查看的内容不存在');
        }
        if ($explore->status != 1) {
            return $this->error('查看的内容不存在');
        }
        $explore->angling;
        if (null === $explore->angling) {
            return $this->error('关联钓场已经停业');
        }
        $has = 0;
        if(isset($this->request->memberId)){
            $has = OrderModel::where([
                    ['member_id','=', $this->request->memberId],
                    ['type','=',3],
                    ['data_id','=',$exploreId],
                    ['is_paid','=',1]
                ])->count() ?? 0;
        }
        return $this->success([
                    'has' => $has,
                    'detail' => [
                        'explore_id' => $exploreId,
                        'title' => $explore->title,
                        'photo' => $explore->photo,
                        'original_price' => $explore->original_price,
                        'price' => $explore->price,
                        'num' => $explore->num,
                        'detail' => $explore->detail,
                    ],
                    'angling' => [
                        'angling_id' => $explore->angling->angling_id,
                        'name' => $explore->angling->name,
                        'photos' => $explore->angling->photos,
                        'addr' => $explore->angling->addr,
                        'lat' => $explore->angling->lat,
                        'lng' => $explore->angling->lng,
                        'mobile'    => $explore->angling->mobile,
                    ]
        ]);
    }

}
