<?php
namespace app\api\controller;
use app\BaseController;
use app\common\model\market\CouponModel;
use app\common\model\member\MemberCouponModel;
use app\common\logic\member\IntegralLogic;
class Coupon extends BaseController{
    
    public function getCouponList(){
        $today = date('Y-m-d',time());
        $where = [
            ['bg_time','<=',$today],
            ['num','>',0],
            ['type','IN',[1,2]]
        ];
        $datas = CouponModel::where($where)
                            ->order(['coupon_id'=>'desc'])
                           ->select()
                           ->toArray();
        $hasIds = [];
        if(isset($this->request->memberId)){
            $couponIds = [];
            foreach($datas as $val){
                $couponIds[] = $val['coupon_id'];
            }
            if(!empty($couponIds)){
                $hasIds = MemberCouponModel::where([
                    ['member_id','=', $this->request->memberId],
                    ['coupon_id','IN',$couponIds]
                ])->column('coupon_id') ?? [];
            }
        }
        return $this->success([
            'datas' => $datas,
            'hasIds' => $hasIds,
        ]);
    }
    
    public function getExchangeCouponList(){
        $today = date('Y-m-d',time());
        $where = [
            ['bg_time','<=',$today],
            ['num','>',0],
            ['type','=',3]
        ];
        
        $datas = CouponModel::where($where)
                            ->order(['coupon_id'=>'desc'])
                           ->select()
                           ->toArray();
    
        return $this->success([
            'datas' => $datas
        ]);
    }
    
    public function getMyCouponList(){
        $today = date('Y-m-d',time());
        $where = [
            ['member_id','=', $this->request->memberId],
            ['expire_time','>=',$today],
            ['status','=',0]
        ];
        $datas = MemberCouponModel::where($where)->order([
            'id'=>'desc'
        ])->select()->toArray();
        return $this->success([
            'datas' => $datas
        ]);
    }
    
    
    
    //领取
    public function receiveCoupon(){
        $coupon_id = $this->request->param('coupon_id/d');
        if(empty($coupon_id)){
            return $this->error('请选择要领取的优惠券');
        }
        if(null === $coupon = CouponModel::find($coupon_id)){
            return $this->error('请选择要领取的优惠券');
        }
        if($coupon->type == 3){
            return $this->error('请选择要领取的优惠券');
        }
        if($coupon->num <= 0){
            return $this->error('已经领完了');
        }
        if($coupon->type == 1){
            if($this->request->member->is_new == 0){
                return $this->error('该券为新用户专享');
            }
        }
        if(MemberCouponModel::where([
            ['member_id','=', $this->request->memberId],
            ['coupon_id','=',$coupon_id]
        ])->count() > 0){
            return $this->error('您已经领取过了');
        }
        $coupon->num = $coupon->num - 1;
        $coupon->save();
        $memberCoupon = new MemberCouponModel();
        $memberCoupon->save([
            'member_id' => $this->request->memberId,
            'coupon_id' => $coupon_id,
            'title' => $coupon->title,
            'money'  => $coupon->money,
            'need_money' => $coupon->need_money,
            'bg_time'  => date('Y-m-d',time()),
            'expire_time' => date('Y-m-d',time() + 86400*$coupon->day),
            'status' => 0
        ]);
       
        return $this->success();
    }
    
    public function exchangeCoupon(){
        $coupon_id = $this->request->param('coupon_id/d');
        if(empty($coupon_id)){
            return $this->error('请选择要兑换的优惠券');
        }
        if(null === $coupon = CouponModel::find($coupon_id)){
            return $this->error('请选择要兑换的优惠券');
        }
        if($coupon->type != 3){
            return $this->error('请选择要兑换的优惠券');
        }
        
        if($coupon->num <= 0){
            return $this->error('该券已经兑换完了');
        }
        if($this->request->member->integral < $coupon->exchange_num){
            return $this->error('您的鱼饵不足');
        }
        
        $memberCoupon = new MemberCouponModel();
        $memberCoupon->save([
            'member_id' => $this->request->memberId,
            'coupon_id' => $coupon_id,
            'title' => $coupon->title,
            'money'  => $coupon->money,
            'need_money' => $coupon->need_money,
            'bg_time'  => date('Y-m-d',time()),
            'expire_time' => date('Y-m-d',time() + 86400*$coupon->day),
            'status' => 0
        ]);
        IntegralLogic::getInstance()->useIntegral($this->request->memberId,$coupon->exchange_num,'兑换优惠券');
        return $this->success();
    }
    
}