<?php
namespace app\api\controller;
use app\BaseController;
use app\common\model\member\ClockModel;
use app\common\model\angling\AnglingModel;
use app\common\model\rapac\RapacModel;
use app\common\logic\member\IntegralLogic;
class Clock extends BaseController{
    
    public function clockAddr(){
        $cityId = $this->request->param('cityId/d');
        if(empty($cityId)){
            return $this->error('定位失败，请开启定位');
        }
        $angling = AnglingModel::where([
            ['city_id','=',$cityId],
            ['is_audit','=',1]
        ])->field('angling_id,name,lat,lng')
        ->limit(200)
       ->select()
       ->toArray();
        $rapac = RapacModel::where([
            ['city_id','=',$cityId],
            ['is_audit','=',1]
        ])->field('rapac_id,name,lat,lng')
        ->limit(200)
       ->select()
       ->toArray();
        return $this->success([
            'angling' => $angling,
            'rapac'   => $rapac  
        ]);
    }
    
    public function index(){
        $where = [];
        $page = $this->request->param('page/d',1);
        $limit = $this->request->param('limit/d',10);
      
        $cityId = $this->request->param('cityId/d');
        if(!empty($cityId)){
            $where[] = ['city_id','=',$cityId];
        }
        $rapacId = $this->request->param('rapacId/d');
        if(!empty($rapacId)){
            $where[] = ['rapac_id','=',$rapacId];
        }
        $anglingId = $this->request->param('anglingId/d');
        if(!empty($anglingId)){
            $where[] = ['angling_id','=',$anglingId];
        }
        $where[] = ['status','=',1];
        $datas = ClockModel::with(['member'=>function($query){
            $query->field('member_id,nickname,face');
        },'angling'=>function($query){
            $query->field('angling_id,name,photos,lng,lat');
        },'rapac'=>function($query){
            $query->field('rapac_id,name,photos,lng,lat');
        }])->where($where)->field('clock_id,type,angling_id,rapac_id,member_id,desc,photos,add_time')
                           ->order(['clock_id'=>'desc']) 
                           ->limit($limit)->page($page)
                           ->select()->append(['add_time_format'])
                           ->toArray();
        
        return $this->success([
            'datas' => $datas
        ]);
    }
    
    public function myList(){
        $where = [];
        $page = $this->request->param('page/d',1);
        $limit = $this->request->param('limit/d',10);
        $where[] = ['member_id','=', $this->request->memberId];
         $datas = ClockModel::with(['angling'=>function($query){
            $query->field('angling_id,name,photos,lng,lat');
        },'rapac'=>function($query){
            $query->field('rapac_id,name,photos,lng,lat');
        }])->where($where)->field('clock_id,type,angling_id,rapac_id,member_id,desc,status,photos,add_time')
                           ->order(['clock_id'=>'desc']) 
                           ->limit($limit)->page($page)
                           ->select()->append(['add_time_format'])
                           ->toArray();
        
        return $this->success([
            'datas' => $datas
        ]);
    }
    
    public function add(){
        $datas = [
            'desc'    => $this->request->param('desc'),
            'photos'      => $this->request->param('photos/a'),
            'member_id'   => $this->request->memberId,  
            'type'     => $this->request->param('type/d'),
            'angling_id'     => $this->request->param('angling_id/d'),
            'rapac_id'     => $this->request->param('rapac_id/d'),
            'status'  => 0,
        ];
        if(empty($datas['desc'])){
            return $this->error('请说点什么');
        }
        if(empty($datas['photos'])){
            return $this->error('请上传图片');
        }     
        if(empty($datas['type'])){
            return $this->error('请选择打卡类型');
        }
  
        if($datas['type'] == 1){
            if(empty($datas['rapac_id'])){
                return $this->error('请选择打卡的钓点');
            }
            if(null === $rapac = RapacModel::find($datas['rapac_id'])){
                return $this->error('请选择打卡的钓点');
            }
            $datas['city_id'] = $rapac->city_id;
        }
         if($datas['type'] == 2){
            if(empty($datas['angling_id'])){
                return $this->error('请选择打卡的钓场');
            }
            if(null === $angling = AnglingModel::find($datas['angling_id'])){
                return $this->error('请选择打卡的钓场');
            }
            $datas['city_id'] = $angling->city_id;
        }
        
        $clock = new ClockModel();
        $clock->save($datas);
        
        IntegralLogic::getInstance()->addIntegralByType('clock', $this->request->memberId);
        return $this->success();
    }
    
    public function detail(){
        $clockId = $this->request->param('clockId/d');
        if(empty($clockId)){
            return $this->error('请选择要查看的打卡记录');
        }
        if(null === $clock = ClockModel::with(['member'=>function($query){
            $query->field('member_id,nickname,face');
        },'angling'=>function($query){
            $query->field('angling_id,name,photos,fish_type,lng,lat');
        },'rapac'=>function($query){
            $query->field('rapac_id,name,photos,fish_type,lng,lat');
        }])->field('clock_id,type,city_id,angling_id,rapac_id,member_id,desc,photos,add_time')->find($clockId)){
             return $this->error('请选择要查看的打卡记录');
        }
        $up = ClockModel::where([
            ['city_id','=',$clock->city_id],
            ['clock_id','<',$clock->clock_id],
            ['status','=',1]
        ])->order(['clock_id'=>'desc'])->find();
        
        $down = ClockModel::where([
            ['city_id','=',$clock->city_id],
            ['clock_id','>',$clock->clock_id],
            ['status','=',1]
        ])->order(['clock_id'=>'asc'])->find();
        
        return $this->success([
            'detail' => $clock->toArray(),
            'up_id'  => $up === null ? 0 : $up->clock_id,
            'down_id' => $down === null ? 0 : $down->clock_id,
        ]);
        
    }
    
    
}
