<?php
namespace app\api\controller;
use app\BaseController;
use app\common\model\angling\AnglingModel;

class Angling extends BaseController{
    
    public function index(){
        $where = [];
        $page = $this->request->param('page/d',1);
        $limit = $this->request->param('limit/d',10);
        $cityId = $this->request->param('cityId/d');
        if(!empty($cityId)){
            $where[] = ['city_id','=',$cityId];
        }
        $where[] = ['is_audit','=',1];
        $fishtype = $this->request->param('fishtype');
        if(!empty($fishtype)){
            $where[] = ['fish_type','LIKE','%'.$fishtype.'%'];
        }
        $keyword = $this->request->param('keyword');
        if(!empty($keyword)){
            $where[] = ['name','LIKE','%'.$keyword.'%'];
        }
        $datas = AnglingModel::where($where)
                            ->field('angling_id,name,photos,fish_type,is_tai,is_lure,addr,lat,lng,rank_num')
                            ->order(['rank_num'=>'desc','angling_id'=>'desc'])->limit($limit)->page($page)
                           ->select()
                           ->toArray();
        return $this->success([
            'datas' => $datas
        ]);
    }
 
    public  function detail(){
        $anglingId = $this->request->param('anglingId/d');
        if(empty($anglingId)){
            return $this->error('请选择要查看的钓场');
        }
        if(null === $angling = AnglingModel::find($anglingId)){
            return $this->error('请选择要查看的钓场');
        }
        $angling->tuan;
        $angling->rank_num = $angling->rank_num + 1;
        $angling->save();
        return $this->success([
            'detail' => [
                'angling_id' => $angling->angling_id,
                'name' => $angling->name,
                'photos' =>$angling->photos,
                'fish_type' =>  empty($rapac->fish_type) ? '' : join('、',$rapac->fish_type ),
                'addr'      => $angling->addr,
                'lat'       => $angling->lat,
                'lng'       => $angling->lng,
                'mobile'       => $angling->mobile,
                'weixin'       => $angling->weixin,
                'rank_num'       => $angling->rank_num,
                'is_tai'       => $angling->is_tai,
                'is_lure'       => $angling->is_lure,
                'detail'       => $angling->detail,
            ],
            'tuan'  => $angling->tuan ?? [],
        ]);
    }
    
    
}
