<?php

use think\facade\Route;

//不需要登陆的页面
Route::group(function (){
    Route::rule('login','login/index'); //后台登陆
});


//总后台其他需要登陆校验的
Route::group(function (){
   
   Route::rule('getHomeCount','index/getCount'); 
   Route::rule('getHomeOrderCount','index/getOrderCount'); 
   Route::rule('getHomeMemberCount','index/getMemberCount'); 
   
   
    //管理员
   Route::rule('getAdminList','admin.index/index'); 
   Route::rule('updateAdmin','admin.index/update'); 
   Route::rule('getAdminDetail','admin.index/detail'); 
   Route::rule('delAdmin','admin.index/del'); 
   Route::rule('delAllAdmin','admin.index/delAll'); 
   Route::rule('editAdmin','admin.index/edit');
   Route::rule('addAdmin','admin.index/add');  

   
   Route::rule('getMpkeywordList','data.Mpkeyword/index'); 
   Route::rule('getMpkeywordDetail','data.Mpkeyword/detail'); 
   Route::rule('delMpkeyword','data.Mpkeyword/del'); 
   Route::rule('delAllMpkeyword','data.Mpkeyword/delAll'); 
   Route::rule('saveMpkeyword','data.Mpkeyword/save');

   
   //上传
   Route::rule('upload','oss.index/upload');
   Route::rule('saveAlbum','oss.index/saveAlbum');
   Route::rule('getPhotoList','oss.index/getList');
   Route::rule('movePhoto','oss.index/movePhoto');
   Route::rule('deletePhoto','oss.index/deletePhoto');
   
   //系统配置
   Route::rule('getSettingData','data.setting/detail');
   Route::rule('saveSettingData','data.setting/save');
   Route::rule('getSiteDomain','data.setting/getDomain');
   Route::rule('createMpMenu','data.setting/createMpMenu');
   
   Route::rule('getAppDatas','app.index/getAppDatas');
   
   Route::rule('cloudRegsiter','cloud.index/regsiter');
   Route::rule('cloudByCode','cloud.index/code');
   Route::rule('getCloudHomeInfo','cloud.index/getCloudHomeInfo');
   
   Route::rule('getAppV','cloud.app/getAppV');
   Route::rule('getAppFile','cloud.app/getAppFile');
   Route::rule('decompressionPhpFile','cloud.app/decompressionPhpFile');
   Route::rule('movePhpFile','cloud.app/movePhpFile');
   Route::rule('installPhpSql','cloud.app/installPhpSql');
   Route::rule('overPhpUpdate','cloud.app/overPhpUpdate');
   Route::rule('getMiniappV','cloud.app/getMiniappV');
   Route::rule('planMiniappResource','cloud.app/planMiniappResource');
   Route::rule('uploadMiniapp','cloud.app/uploadMiniapp');
   Route::rule('overMiniapp','cloud.app/overMiniapp');
   

   
   //会员列表
   Route::rule('getMemberList','member.member/index');
   Route::rule('saveMemberData','member.member/save');
   Route::rule('delMemberData','member.member/del');
   Route::rule('delAllMemberData','member.member/delAll');
   
   Route::rule('getMemberIntegralList','member.integral/index');
   Route::rule('saveMemberIntegralData','member.integral/save');
   
   //打开记录
   Route::rule('getClockList','member.clock/index');
   Route::rule('saveClockData','member.clock/save');
   Route::rule('delClockData','member.clock/del');
   Route::rule('delAllClockData','member.clock/delAll');
   Route::rule('auditClockData','member.clock/audit');
   
   //城市列表
   Route::rule('getCityList','data.city/index');
   Route::rule('getAllCity','data.city/datas');
   Route::rule('delCity','data.city/del');
   Route::rule('delAllCity','data.city/delAll');
   Route::rule('saveCity','data.city/save');
   
   //banner
   Route::rule('getBannerList','data.banner/index');
   Route::rule('delBanner','data.banner/del');
   Route::rule('delAllBanner','data.banner/delAll');
   Route::rule('saveBanner','data.banner/save');

   
   //团建订单
   Route::rule('getTeamBuildingList','team.building/index');
   Route::rule('getTeamBuildingDetail','team.building/detail');
   Route::rule('delTeamBuilding','team.building/del');
   Route::rule('delAllTeamBuilding','team.building/delAll');
   Route::rule('saveTeamBuilding','team.building/save');
   
   
   //订单管理
   Route::rule('getOrderList','order.order/index');
   Route::rule('refundYes','order.order/refundYes');
   Route::rule('refundNo','order.order/refundNo');
   
   //野钓地点
   Route::rule('getRapacList','rapac.rapac/index');
   Route::rule('saveRapacData','rapac.rapac/save');
   Route::rule('delRapacData','rapac.rapac/del');
   Route::rule('delAllRapacData','rapac.rapac/delAll');
   //鱼塘
   Route::rule('getAnglingList','angling.angling/index');
   Route::rule('saveAnglingData','angling.angling/save');
   Route::rule('delAnglingData','angling.angling/del');
   Route::rule('delAllAnglingData','angling.angling/delAll');
   

   
   Route::rule('getAnglingFreeList','angling.free/index');
   Route::rule('saveAnglingFreeData','angling.free/save');
   Route::rule('delAnglingFreeData','angling.free/del');
   Route::rule('delAllAnglingFreeData','angling.free/delAll');
   
   Route::rule('getAnglingManageList','angling.manage/index');
   Route::rule('saveAnglingManageData','angling.manage/save');
   Route::rule('delAnglingManageData','angling.manage/del');
   Route::rule('delAllAnglingManageData','angling.manage/delAll');
   
   Route::rule('getAnglingTuanList','angling.tuan/index');
   Route::rule('saveAnglingTuanData','angling.tuan/save');
   Route::rule('delAnglingTuanData','angling.tuan/del');
   Route::rule('delAllAnglingTuanData','angling.tuan/delAll');
   
   
   //商家收入及提现管理
   Route::rule('getMoneyList','angling.money/index');
   Route::rule('getCashList','angling.money/cash');
   Route::rule('changeCashStatus','angling.money/changeCashStatus');
   
   
   
   Route::rule('getHuodongList','huodong.huodong/index');
   Route::rule('getHuodongData','huodong.huodong/detail');
   Route::rule('saveHuodongData','huodong.huodong/save');
   Route::rule('delHuodongData','huodong.huodong/del');
   Route::rule('delAllHuodongData','huodong.huodong/delAll');
   
   Route::rule('getExploreList','explore.explore/index');
   Route::rule('getExploreData','explore.explore/detail');
   Route::rule('saveExploreData','explore.explore/save');
   Route::rule('delExploreData','explore.explore/del');
   Route::rule('delAllExploreData','explore.explore/delAll');
   
   
   Route::rule('getCouponList','market.Coupon/index');
   Route::rule('saveCouponData','market.Coupon/save');
   Route::rule('delCouponData','market.Coupon/del');
   Route::rule('delAllCouponData','market.Coupon/delAll');
   
   Route::rule('getLotteryList','market.lottery/index');
   Route::rule('saveLotteryData','market.lottery/save');
   Route::rule('delLotteryData','market.lottery/del');
   Route::rule('delAllLotteryData','market.lottery/delAll');
   Route::rule('getLotteryJoinList','market.lottery/getJoinList');
   Route::rule('openLotteryRewards','market.lottery/rewards');
   
})->middleware(\app\admin\middleware\AdminCheck::class);
