<?php
namespace app\admin\middleware;
use app\common\helper\token\TokenHelper;
use app\common\logic\admin\AdminLogic;
class AdminCheck {
    use \app\BaseTrait;
     public function handle($request, \Closure $next)
    {   
        $auth_token = $request->param('token'); 
        if(empty($auth_token)){
            return $this->error('登录状态已经失效,请重新登录',100);
        }
        $res = TokenHelper::getId($auth_token);
        if(false == $res){
            return $this->error('登录状态已经失效,请重新登录',100);
        }
        if($res === 0){
            return $this->error('登录状态已经失效,请重新登录',100);
        } 
        $adminLogic = AdminLogic::getInstance($res);
        if(null === $adminLogic){
            return $this->error('登录状态已经失效,请重新登录',100);
        }
        $request->admin   = $adminLogic->getData();
        if($request->admin->is_delete == 1){
            return $this->error('管理员已经被删除，请重新登录',100);
        }
        if($request->admin->role !== 1){
            return $this->error('该管理员非超级管理员',100);  
        }
        $request->adminId = $res;
        $adminLogic->setLastTime()->save();//更新最后活跃时间
        return $next($request);
     }
    
}