<?php
namespace app\admin\controller\team;
use app\BaseController;
use app\common\model\team\TeamBuildingModel;
class  Building extends BaseController{
    
     public function  index(){
        $return = $where = [];
        $page = $this->request->param('page/d',1);
        $limit = $this->request->param('limit/d',10);
        $keyword = $this->request->param('keyword');
        if(!empty($keyword)){
            $where[] = ['name|company|mobile','LIKE','%'.$keyword.'%'];
        }
        $cityId = $this->request->param('cityId/d');
        if(!empty($cityId)){
            $where[] = ['city_id','=',$cityId];
        }
        
        $type = $this->request->param('type/d');
        if(!empty($type)){
            if($type == 1){
                $where[] = ['status','=',0];
            }else{
                $where[] = ['status','=',1];
            }
        }
        $return['count'] = TeamBuildingModel::where($where)->count();
        $return['datas'] = TeamBuildingModel::with('city')->where($where)->field('id,city_id,company,num,budget,is_take,name,mobile,info,status,add_time')
                           ->order(['id'=>'desc']) 
                           ->limit($limit)->page($page)
                           ->select()->append(['add_time_format'])
                           ->toArray();
        return $this->success($return);
    }
    
    public function detail(){
        $id = $this->request->param('id/d');
        if(empty($id)){
            return $this->error('您要获取的数据不存在');
        }
        if(null === $data = TeamBuildingModel::find($id)){
            return $this->error('您要获取的数据不存在');
        }
        return $this->success([
            'detail' => [
                'id'     => $data->id,
                'city_id' => $data->city_id,
                'company'  => $data->company,
                'num'       => $data->num,
                'budget'        => $data->budget,
                'is_take'    => $data->is_take,
                'name'     => $data->name,
                'mobile'        => $data->mobile,
                'info'  => $data->info,
                'day'   => $data->day,
                'status'    => $data->status,
            ],
        ]);
    }
    
    public function del(){
        $id = $this->request->param('id/d');
        if(empty($id)){
            return $this->error('请选择要删除的数据');
        }
        if(null === $data = TeamBuildingModel::find($id)){
            return $this->error('请选择要删除的数据');
        }
        $data->delete();
        return $this->success('操作成功');
    }
    
    public function delAll(){
        $ids = $this->request->param('ids/a');
        if(empty($ids)){
            return $this->error('请选择要删除的数据');
        }
        foreach($ids as $key=>$val){
            $ids[$key] = (int)$val;
        }
        TeamBuildingModel::where([
            ['id','IN',$ids]
        ])->delete();
        return $this->success('操作成功');
    }
    
    public function save(){
        $id = $this->request->param('id/d');
        $datas = [
            'city_id' => $this->request->param('city_id/d'),
            'company'  => $this->request->param('company'),
            'num'       => $this->request->param('num/d'),
            'budget'        => $this->request->param('budget'),
            'is_take'    => $this->request->param('is_take/d'),
            'name'     => $this->request->param('name'),
            'mobile'        => $this->request->param('mobile'),
            'info'  => $this->request->param('info'),
            'day'   => $this->request->param('day'),
            'status'    => $this->request->param('status/d'),
        ];
        if(empty($datas['city_id'])){
            return $this->error('请选择城市');
        }
        if(empty($datas['company'])){
            return $this->error('请填写团队或者公司名称');
        }
        if(empty($datas['num'])){
            return $this->error('请输入大概人数');
        }
      
        if(empty($datas['name'])){
            return $this->error('对接联系人不能为空');
        }
        if(!is_mobile($datas['mobile'])){
            return $this->error('请填写手机号码');
        }
        if(!empty($id)){
            if(null === $data = TeamBuildingModel::find($id)){
                return $this->error('请选择要编辑的团建订单');
            }
        }else{
            $data = new TeamBuildingModel();
        }
        $data->save($datas);
        return $this->success();
    }
    
}